package com.yizhi.core.application.task;

import com.yizhi.core.application.log.TaskLogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 导入导出任务线程类
 * @author scotthu
 * @date 2018年2月24日
 */
public class CloudTask implements Runnable{
	
	private AbstractTaskHandler taskHandler;
	
	private static final Logger logger = LoggerFactory.getLogger(CloudTask.class);
	
	public CloudTask(AbstractTaskHandler taskHandler) {
		this.taskHandler = taskHandler;
	}

	@Override
	public void run() {
		try {
			taskHandler.handle();
		} catch (Exception e) {
			logger.error("异步任务执行中出现异常:",e);
			taskHandler.publishTaskEvent(TaskLogEvent.fail(taskHandler.taskContext,"异步任务执行中出现异常，请查看后台日志"));
		}
	}

}
