package com.yizhi.application.discovery;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.yizhi.core.application.cache.RedisCache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @ClassName ContainerCache
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2020/12/1 09:57
 * @Version 1.0
 */
public class ContainerCache {

    private DiscoveryProperties discoveryProperties;

    private RedisCache redisCache;

    public ContainerCache() {
    }

    public ContainerCache(DiscoveryProperties discoveryProperties, RedisCache redisCache) {
        this.discoveryProperties = discoveryProperties;
        this.redisCache = redisCache;
    }

    /**
     * 获取 路由标示
     *
     * @return
     */
    public String serviceRouteVersion() {
        Object serviceRouteVersion = redisCache.get(discoveryProperties.getCacheName());
        if (serviceRouteVersion != null) {
            return serviceRouteVersion.toString();
        }

        // 获取服务列表
        HttpResponse response = HttpUtil.createGet(discoveryProperties.getNacosServiceListUrl())
                .form("pageNo", 1)
                .form("pageSize", 100)
                .form("namespaceId", discoveryProperties.getNamespaceId())
                .execute();
        JSONArray servicesJson = JSON.parseObject(response.body()).getJSONArray("doms");
        Map<String, String> serviceEnableGrayMap = new HashMap<>();

        servicesJson.forEach(serviceName -> {
            serviceEnableGrayMap.put(serviceName.toString(),
                    has41Container(serviceName.toString()) ? discoveryProperties.getRcVersion() : discoveryProperties.getReleaseVersion());
        });

        if (serviceEnableGrayMap.isEmpty()) {
            return discoveryProperties.getReleaseVersion();
        }
        String res = JSON.toJSONString(serviceEnableGrayMap);
        redisCache.set(discoveryProperties.getCacheName(), res, discoveryProperties.getCacheExpirationSeconds());
        return res;
    }

    /**
     * 查询服务是否有 4.0_RC 版本号的容器
     *
     * @param serviceName
     * @return
     */
    private boolean has41Container(String serviceName) {
        HttpResponse response = HttpUtil.createGet(discoveryProperties.getNacosInstanceListUrl())
                .form("serviceName", serviceName)
                .form("namespaceId", discoveryProperties.getNamespaceId())
                .execute();

        JSONArray jsonArray = JSON.parseObject(response.body()).getJSONArray("hosts");

        List<Instance> instances = jsonArray.toJavaList(Instance.class);

        Optional optional = instances.stream().filter(item -> discoveryProperties.getRcVersion().equals(item.getMetadata().get("version"))).findFirst();
        return optional.isPresent();
    }

}
