package com.yizhi.application.filter;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import com.netflix.zuul.context.RequestContext;

/**
 * @ClassName LogPostFilter
 * @Description 请求日志 先记录请求到达时间点，存放redis --> 后面交给 LogPostFilter 处理
 * @Author shengchenglong
 * @DATE 2021/1/11 11:19
 * @Version 1.0
 */
@Component
@Slf4j
public class LogPreFilter extends BaseZuulFilter {

	public static final String GATEWAY_LOG_START_TIME_HEADER = "gateway_log_start_time";

	@Value("${gateway.logSwitch:false}")
	private Boolean logSwitch;

	@Autowired
	private RedisTemplate redisTemplate;

	@Override
	public boolean shouldFilter() {
		return logSwitch;
	}

	@Override
	public Object run() {

		RequestContext.getCurrentContext().addZuulRequestHeader(GATEWAY_LOG_START_TIME_HEADER, String.valueOf(System.currentTimeMillis()));

		return null;
	}
}

