package com.yizhi.application.controller.manage;

import com.yizhi.application.domain.TaskLog;
import com.yizhi.application.domain.TaskLogDetail;
import com.yizhi.application.service.TaskLogDetailService;
import com.yizhi.application.service.TaskLogService;
import com.yizhi.log.application.vo.TaskLogDetailPageVO;
import com.yizhi.log.application.vo.TaskLogDetailVO;
import com.yizhi.log.application.vo.TaskLogPageVO;
import com.yizhi.log.application.vo.TaskLogVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.application.orm.page.PageUtil;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.page.PageInfo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 任务管理接口
 * @author yinyuyan 2018/5/21
 *
 */
@Api(tags = "任务管理接口")
@RestController
@RequestMapping(value="/manage/tasklog")
public class TaskLogController {
	private static final Logger logger = LoggerFactory.getLogger(TaskLogController.class);

	@Autowired
	TaskLogService taskLogService;
	@Autowired
	TaskLogDetailService taskLogDetailService;
	@Autowired
	DomainConverter converter;
	
	@ApiOperation(value = "任务列表接口", notes = "任务列表接口")
	@PostMapping(value = "/list")
	public Response<TaskLog> list(@RequestBody TaskLogPageVO pageVO){
		try {
			TaskLog taskLog=(TaskLog)converter.toDO(pageVO, TaskLog.class);
			taskLog.setCompanyId(ContextHolder.get().getCompanyId());
			taskLog.setSiteId(ContextHolder.get().getSiteId());
			if (!ContextHolder.get().isAdmin()) {
				taskLog.setSubmitterId(ContextHolder.get().getAccountId());
			}
			PageInfo<TaskLog> pageInfo=new PageInfo<>();
        	pageInfo.setPageNo(pageVO.getPageNo());
        	pageInfo.setPageSize(pageVO.getPageSize());
			Page<TaskLog> page = taskLogService.list(taskLog, PageUtil.vice(pageInfo));
			return Response.ok(PageUtil.versa(converter.toPageVO(page, TaskLogVO.class)));
		}catch (BizException be) {
			return Response.fail(be.getCode(),be.getMsg());
		} catch (Exception e) {
			logger.error("", e);
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
	
	@ApiOperation(value = "任务详情列表接口", notes = "任务详情列表接口")
	@PostMapping(value = "/detail/list")
	public Response<TaskLogDetailVO> getTaskLogDetails(@RequestBody TaskLogDetailPageVO pageVO){
		try {
			TaskLogDetail taskLogDetail=(TaskLogDetail)converter.toDO(pageVO, TaskLogDetail.class);
			PageInfo<TaskLogDetail> pageInfo=new PageInfo<>();
        	pageInfo.setPageNo(pageVO.getPageNo());
        	pageInfo.setPageSize(pageVO.getPageSize());
			Page<TaskLogDetail> page = taskLogDetailService.listDetails(taskLogDetail, PageUtil.vice(pageInfo));
			return Response.ok(PageUtil.versa(converter.toPageVO(page, TaskLogDetailVO.class)));
		}catch (BizException be) {
			return Response.fail(be.getCode(),be.getMsg());
		} catch (Exception e) {
			logger.error("", e);
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}

}
