package com.yizhi.application.controller.manage.remote;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.application.domain.TaskLog;
import com.yizhi.log.application.vo.TaskLogVO;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.application.service.TaskLogDetailService;
import com.yizhi.application.service.TaskLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

/**
 * 任务管理接口
 *
 * @author yinyuyan 2018/5/21
 */
@Api(tags = "任务管理接口")
@RestController
@RequestMapping(value = "/remote/tasklog/")
public class RemoteTaskLogController {
    private static final Logger logger = LoggerFactory.getLogger(RemoteTaskLogController.class);

    @Autowired
    TaskLogService taskLogService;
    @Autowired
    TaskLogDetailService taskLogDetailService;
    @Autowired
    DomainConverter converter;

    @ApiOperation(value = "获取当前时间的过去七天的 任务列表接口", notes = "任务列表接口")
    @GetMapping(value = "/getList")
    public List<TaskLogVO> list() {

        TaskLog taskLog = new TaskLog();
        taskLog.setSiteId(ContextHolder.get().getSiteId());

        Date currentDate = new Date();
        DateTime beforeDate = DateUtil.offsetDay(currentDate, -6);
        //获取七天前的开始时间
        Date preStartDate = DateUtil.beginOfDay(beforeDate);
        //获取今天的结束时间
        Date preEndDate = DateUtil.endOfDay(currentDate);


        List<TaskLog> page = taskLogService.listByDate(taskLog, preStartDate, preEndDate);
        List<TaskLogVO> list = converter.toDOList(page, TaskLogVO.class);
        return list;
    }


}
