package com.yizhi.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.log.TaskLogEvent;
import com.yizhi.application.domain.TaskLog;

import java.util.Date;
import java.util.List;

/**
 * 异步任务日志服务接口
 *
 * @author scotthu
 * @date 2018年3月19日
 */
public interface TaskLogService {

    /**
     * 保存任务日志事件
     *
     * @param taskLogEvent
     */
    void add(TaskLogEvent taskLogEvent);

    /**
     * 分页返回任务日志列表
     *
     * @return 任务日志分页数据
     */
    Page<TaskLog> list(TaskLog taskLog, Page<TaskLog> page);

    /**
     * 分页返回任务日志列表
     *
     * @return 任务日志分页数据
     */
    List<TaskLog> listByDate(TaskLog taskLog, Date startDate, Date endDate);
}
