package com.yizhi.application;

import com.baomidou.mybatisplus.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.plugins.parser.ISqlParser;
import com.yizhi.application.orm.hierarchicalauthorization.HierarchicalAuthorizationSelectSqlParser;
import com.yizhi.application.orm.tenant.TenantEntityHolder;
import com.yizhi.application.orm.tenant.TenantSqlParser;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;

@Configuration
@MapperScan(basePackages = "com.yizhi.**.mapper")
public class MybatisConfig {

//    @Autowired
//    private datasource
//
//    public SqlSessionFactoryBean sqlSessionFactoryBean() {
//        MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
//        sqlSessionFactoryBean.setDataSource();
//    }

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setLocalPage(true);// 开启 PageHelper 的支持
        List<ISqlParser> sqlParserList = new ArrayList<>();
        TenantSqlParser tenantSqlParser = new TenantSqlParser();
        sqlParserList.add(tenantSqlParser);
        sqlParserList.add(new HierarchicalAuthorizationSelectSqlParser());
        paginationInterceptor.setSqlParserList(sqlParserList);

        return paginationInterceptor;
    }

    @PostConstruct
    public void initTenantEntityHolder() {
        TenantEntityHolder.scan(new String[]{"com.yizhi.application.**.domain"});
    }


}
