package com.yizhi.system.application.feign;

import com.yizhi.system.application.vo.domain.Internationalization;
import com.yizhi.system.application.vo.InternationalizationVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "system", contextId = "InternationalizationClient")
public interface InternationalizationClient {

	@ApiOperation(value = "新增需要国际化的字段", notes = "新增国际化")
	@PostMapping(value = "/manage/internationalization/remote/add")
	public String add(@RequestBody Internationalization vo);

	@ApiOperation(value = "修改需要国际化的字段", notes = "修改国际化")
	@PostMapping(value = "/manage/internationalization/remote/update")
	public String update(@RequestBody InternationalizationVo vo);

	@ApiOperation(value = "删除需要国际化的字段", notes = "删除国际化")
	@PostMapping(value = "/manage/internationalization/remote/deleted")
	public String deleted(@RequestBody InternationalizationVo vo);

}
