package com.yizhi.system.application.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 账号站点对应model
 *
 * @Author: shengchenglong
 * @Date: 2018/5/18 14:12
 */
@Data
public class AuthAccountSiteModel implements Serializable {

    private Map<String, Set<Long>> urlRanges;

    /**
     * 是否是站点管理员
     */
    private Boolean siteAdmin = false;

    /**
     * 账号类型
     * <p>
     * 1. 前端学员
     * 2. 既是前端学员，也是后端管理员
     */
    private Integer accountType;

}