package com.yizhi.system.application.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yizhi.system.application.enums.SiteNoticeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

@Data
@Api(value = "站点维护通知类型")
public class SiteNoticeReq {

    @ApiModelProperty(value = "维护通知id")
    private String id;
    /**
     * 通知类型  INNER站内 CLOSE关站
     */
    @ApiModelProperty(value = "通知类型")
    private SiteNoticeEnum noticeType;

    @ApiModelProperty(value = "维护通知文案内容")
    private String message;

    @ApiModelProperty(value = "维护通知开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date startTime;

    @ApiModelProperty(value = "维护通知结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date endTime;

    public Long getId() {
        return StringUtils.isBlank(id)?null:Long.parseLong(id);
    }
}
