/**
 * 
 */
package com.yizhi.system.application.system.remote;

import com.yizhi.system.application.vo.UserGroupVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户组feign接口
 * @author Administrator
 *
 */

@FeignClient(value = "system", contextId = "GroupClient")
public interface GroupClient {
	/**
	 * 根据用户组id获取详情
	 * @param groupId
	 * @return
	 */
	@RequestMapping(value = "/remote/group/get", method=RequestMethod.GET)
	public UserGroupVO findById(@RequestParam("groupId") Long groupId);


	/**
	 * 社群企业同步
	 * @param date
	 * @return
	 */
	@GetMapping(value="/remote/group/public/community/syncUserGroup")
	public String syncUserGroup(@RequestParam("indexTime") String indexTime);
}