package com.yizhi.system.application.system.remote;

import java.util.List;

import com.yizhi.system.application.vo.domain.LanguageClassify;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import io.swagger.annotations.ApiOperation;

@FeignClient(value = "system", contextId = "LanguageClassifyClient")
public interface LanguageClassifyClient {

	@ApiOperation("新增语种")
	@PostMapping("/remote/languageClassify/save")
	public int save(@RequestBody LanguageClassify languageClassify);
	
	@ApiOperation("修改语种")
	@PostMapping("/remote/languageClassify/update")
	public int update(@RequestBody LanguageClassify languageClassify);
	
	@ApiOperation("删除语种")
	@GetMapping("/remote/languageClassify/delete")
	public int delete(@RequestParam(name = "id") Long id);
	
	@ApiOperation("语种排序")
	@PostMapping("/remote/languageClassify/sort")
	public int sort(@RequestBody List<LanguageClassify> languageClassifies);
	
	@ApiOperation("语种列表")
	@GetMapping("/remote/languageClassify/list")
	public List<LanguageClassify> list(@RequestParam(name = "type") Integer type);
}
