package com.yizhi.system.application.system.remote;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.system.application.vo.*;
import com.yizhi.system.application.vo.domain.LoginLog;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 19:17 2018/8/28
 * @Modified By
 */
@FeignClient(value = "system", contextId = "LoginLogClient")
public interface LoginLogClient {

    /**
     * 添加新的登陆日志信息
     * @param vo
     * @return
     */
    @PostMapping("/remote/loginLog/add/log")
    public Boolean addLoginLog(@RequestBody LoginLogAddReqVO vo);

    /**
     * 获取图表显示信息
     * @param startDate
     * @param endDate
     * @param type
     * @return
     */
    @GetMapping("/remote/loginLog/chart/view")
    public List<LoginUserChartVO> loginLogChart(
            @RequestParam(name = "startDate", required = true) String startDate,
            @RequestParam(name = "endDate", required = true) String endDate,
            @RequestParam(name = "type", required = true, defaultValue = "1") Integer type
    );

    /**
     * 按组织获取登陆统计列表信息
     * @param startDate
     * @param endDate
     * @param kwd
     * @param pageSize
     * @param pageNo
     * @return
     */
    @GetMapping("/remote/loginLog/list/org")
    public Page<LoginUserOrgExportVO> loginLogByOrg(
            @RequestParam(name = "startDate", required = true) String startDate,
            @RequestParam(name = "endDate", required = true) String endDate,
            @RequestParam(name = "kwd", required = false) String kwd,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo
    );

    /**
     * 按用户获取登陆统计列表信息
     * @param startDate
     * @param endDate
     * @param kwd
     * @param pageSize
     * @param pageNo
     * @return
     */
    @GetMapping("/remote/loginLog/list/account")
    public Page<LoginUserExportVO> loginLogByAccount(
            @RequestParam(name = "startDate", required = true) String startDate,
            @RequestParam(name = "endDate", required = true) String endDate,
            @RequestParam(name = "kwd", required = false) String kwd,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo
    );

    @PostMapping("/remote/loginLog/list/org/export")
    public List<LoginUserOrgExportVO> loginLogByOrgExp(@RequestBody Map<String,Object> parament);

    @PostMapping("/remote/loginLog/list/account/export")
    public List<LoginUserExportVO> loginLogByAccountExp(@RequestBody Map<String,Object> parament);
    
    /**
     * 首页访问人次=登陆人次
     */
    @GetMapping("/remote/loginLog/look/num")
    public Integer loginLookNum(@RequestParam("siteId")Long siteId,@RequestParam("loginType")Integer loginType);
    
    
    @GetMapping("/remote/loginLog/count")
    public LoginDataStatisticsVO loginCount(@RequestParam("siteId")Long siteId);
    
    @GetMapping("/remote/loginLog/list/date")
    public List<LoginLog> getLogByDate(@RequestParam("siteId")Long siteId, @RequestParam("accountId")Long accountId);
}
