package com.yizhi.system.application.system.remote;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.system.application.vo.*;
import com.yizhi.util.application.page.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @Author: XieHaijun
 * @Description: 报表导出相关
 * @Date: Created in 9:30 2018/7/17
 * @Modified By
 */
@FeignClient(value = "system", contextId = "ReportClient")
public interface ReportClient {

    /**
     * 获取用户列表信息
     *
     * @param reportAccountVO
     * @return
     */
    @PostMapping(value = "/remote/report/account/list")
    PageInfo<ReportAccountRespVO> getAccounts(@RequestBody ReportAccountReqVO reportAccountVO);

    /**
     * 获取部门列表
     *
     * @param reportOrgReqVO
     * @return
     */
    @PostMapping(value = "/remote/report/org/list")
    PageInfo<ReportOrgRespVO> getOrgs(@RequestBody ReportOrgReqVO reportOrgReqVO);

    /**
     * 根据组织id查询组织下的用户ID列表
     *
     * @param orgId
     * @return
     */
    @GetMapping(value = "/remote/report/org/account/list")
    List<Long> getAccountsByOrgId(@RequestParam(value = "orgId") Long orgId);

    /**
     * 询站点下的用户名和用户id列表
     *
     * @param siteId
     * @return
     */
    @GetMapping("/remote/report/account/site/accounts")
    Map<String, Long> findSiteAccountIds(@RequestParam("siteId") Long siteId);

    /**
     * 根据指定范围查询范围内的用户信息
     *
     * @param rangeAccountReqVO
     * @return
     */
    @PostMapping(value = "/remote/report/account/range/list")
    List<ReportAccountRespVO> getRangeAccounts(@RequestBody ReportRangeAccountReqVO rangeAccountReqVO);

    @PostMapping(value = "/remote/report/account/range/list/inManage")
    ReportAccountRespInManageVO getRangeAccountsInManage(@RequestBody HQAccountInManageParam param);

    /**
     * 根据指定范围查询范围内的用户信息
     *
     * @param rangeAccountReqVO
     * @return
     */
    @PostMapping(value = "/remote/report/account/range/list/page")
    Page<ReportAccountRespVO> getRangeAccountsPage(@RequestBody ReportRangeAccountReqVO rangeAccountReqVO);

    @PostMapping(value = "/remote/report/account/range/list/inManage/page")
    Page<ReportAccountRespVO> getRangeAccountsInManagePage(@RequestBody HQAccountInManageParam param);

    /**
     * 根据指定范围查询范围内的用户人数
     *
     * @param rangeAccountReqVO
     * @return
     */
    @PostMapping(value = "/remote/report/account/range/count")
    Long getRangeAccountCountNum(@RequestBody ReportRangeAccountReqVO rangeAccountReqVO);
}
