package com.yizhi.system.application.utils.recursion;

import java.util.stream.Stream;

/**
 * 尾递归函数接口
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 11:19 2018/4/24
 * @Modified By
 */
@FunctionalInterface
public interface TailRecursion<T> {


    TailRecursion<T> apply();


    default boolean isFinished(){
        return false;
    }


    default T getResult()  {
        throw new Error("递归还没有结束,调用获得结果异常!");
    }


    default T invoke() {
        return Stream.iterate(this, TailRecursion::apply)
                .filter(TailRecursion::isFinished)
                .findFirst()
                .get()
                .getResult();
    }


}
