package com.yizhi.system.application.utils.recursion;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 15:26 2018/4/26
 * @Modified By
 */
@ApiModel(value = "TreeOrg", description = "树形结构")
public class TreeObjectVO {

    @ApiModelProperty(value = "树数据唯一主键id")
    private Long id;

    @ApiModelProperty(value = "树数据的code编码")
    private String code;

    @ApiModelProperty(value = "树数据的名称字段")
    private String name;

    @ApiModelProperty(value = "树数据的别名字段")
    private String enName;

    @ApiModelProperty(value = "树数据的父级id，如果是顶级该字段可以为空")
    private Long parentId;

    @ApiModelProperty(value = "树数据的叶子节点集合")
    private List<TreeObjectVO> subList;

    @ApiModelProperty(value = "树数据的直属叶子")
    private TreeObjectVO member;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnName() {
        return enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public List<TreeObjectVO> getSubList() {
        return subList;
    }

    public void setSubList(List<TreeObjectVO> subList) {
        this.subList = subList;
    }

    public TreeObjectVO getMember() {
        return member;
    }

    public TreeObjectVO setMember(TreeObjectVO member) {
        this.member = member;
        return this;
    }

    public TreeObjectVO cloneThos() {
        return this;
    }
}
