package com.yizhi.system.application.vo;

import com.baomidou.mybatisplus.annotations.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 用户
 * </p>
 *
 * @author moniyin
 * @since 2018-03-12
 */
@Data
@ApiModel(value = "AccountOrgsVO", description = "用户基本信息以及所在组织的父级组织信息")
public class AccountOrgsVO {

    @ApiModelProperty(value = "id")
	private Long id;

    @ApiModelProperty(value = "账号名称")
	private String name;

    @ApiModelProperty(value = "用户状态")
	private String status;

    @ApiModelProperty(value = "座机")
	private String telephone;

    @ApiModelProperty(value = "手机号")
	private String mobile;

    @ApiModelProperty(value = "邮箱地址")
	private String email;

    @ApiModelProperty(value = "性别(‘M’:男,'F':女)")
	private String sex;

    @ApiModelProperty(value = "全名")
	private String fullName;

    @ApiModelProperty(value = "工号")
	private String workNum;

    @ApiModelProperty(value = "部门名称")
    private String orgName;

    @ApiModelProperty(value = "部门id")
    private Long orgId;

    @ApiModelProperty(value = "父级部门名称")
    private List<String> orgNames;

}
