package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 用户
 * </p>
 *
 * @author moniyin
 * @since 2018-03-12
 */
@Data
@ApiModel(value = "AccountVO", description = "用户对象传输类")
public class AccountVO {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "账号名称")
    private String name;

    @ApiModelProperty(value = "头像")
    private String headPortrait;

    @ApiModelProperty(value = "是否开通")
    private Boolean enabled;

    @ApiModelProperty(value = "是否锁定")
    private Boolean locked;

    @ApiModelProperty(value = "座机")
    private String telephone;

    @ApiModelProperty(value = "手机号")
    private String mobile;

    @ApiModelProperty(value = "邮箱地址")
    private String email;

    @ApiModelProperty(value = "过期类型(1长期，2周期，对应字段：startTime，endTime，3天数，对应字段：expiredTime)")
    private Integer expiredType;

    @ApiModelProperty(value = "是否是第一次登录")
    private Boolean firstLogin;

    @ApiModelProperty(value = "第一次登录时间")
    private Date firstLoginTime;

    @ApiModelProperty(value = "上一次登录时间")
    private Date lastLoginTime;

    @ApiModelProperty(value = "账户锁定时间")
    private Date lockedTime;

    @ApiModelProperty(value = "账号生效时间")
    private Date enabledTime;

    @ApiModelProperty(value = "账户过期时间")
    private Date expiredTime;

    @ApiModelProperty(value = "盐")
    private String salt;

    @ApiModelProperty(value = "开始时间")
    private Date startTime;

    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    @ApiModelProperty(value = "性别(‘M’:男,'F':女)")
    private String sex;

    @ApiModelProperty(value = "职位")
    private String position;

    @ApiModelProperty(value = "微信")
    private String wechat;

    @ApiModelProperty(value = "微信图片")
    private String wechatPic;

    @ApiModelProperty(value = "有效天数")
    private Integer validDays;

    @ApiModelProperty(value = "全名")
    private String fullName;

    @ApiModelProperty(value = "工号")
    private String workNum;

    @ApiModelProperty(value = "账号描述")
    private String description;

    @ApiModelProperty(value = "角色列表")
    private List<RoleVO> roleVOs;

    @ApiModelProperty(value = "部门id")
    private Long orgId;

    @ApiModelProperty(value = "部门名称")
    private String orgName;

    @ApiModelProperty(value = "部门全名称")
    private String orgFullName;

    @ApiModelProperty(value = "公司id")
    private Long companyId;

    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "企业地址")
    private String companyAddress;

    @ApiModelProperty(value = "启禁用日志")
    private List<AccountEnableLogVO> logs;

    @ApiModelProperty(value = "app注册id")
    private String appRegistrationId;

    @ApiModelProperty(value = "备注1")
    private String remarkFirst;

    @ApiModelProperty(value = "备注2")
    private String remarkSecond;

    @ApiModelProperty(value = "备注3")
    private String remarkThird;

    @ApiModelProperty(value = "是否绑定微信，true 绑定，false 未绑定")
    private Boolean bindWeChat;

    @ApiModelProperty(value = "学员个人信息修改编辑权限")
    private StudentEditPermissionVO editPermissionVO;

    @ApiModelProperty(value = "关联角色名称")
    private String relationRoleNames;
}
