package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;


@ApiModel(value = "companyVO", description = "新增企业封装")
@Data
public class CompanyVO {

    @ApiModelProperty(value = "授权码")
    private String authCode;

    @ApiModelProperty(value = "公司Id")
    private Long id;

    @ApiModelProperty(value = "公司名字")
    private String name;

    @ApiModelProperty(value = "公司类型1保险2金融3证券4其它")
    private Integer categoryId;

    @ApiModelProperty(value = "公司编码")
    private String code;

    @ApiModelProperty(notes = "1初始化/2停用/3启用")
    private Integer status;

    @ApiModelProperty(value = "公司logo地址")
    private String logo;

    @ApiModelProperty(value = "公司简介")
    private String context;

    @ApiModelProperty(value = "公司地址")
    private String address;

    @ApiModelProperty(value = "到期时间")
    private Date expiredTime;

    @ApiModelProperty(value = "企业域名")
    private String domain;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "联系人列表")
    private List<ContactorVO> contactorVOs;

    @ApiModelProperty(notes = "企业成员数")
    private Integer memberCount;

    @ApiModelProperty(notes = "企业禁用员工数")
    private Integer memberCloseCount;

    @ApiModelProperty(notes = "企业部门数")
    private Integer orgCount;

    @ApiModelProperty(notes = "管理员信息")
    private AccountRegisterVO superAdmin;

    /**
     * 默认跟组织id
     */
    private Long rootOrgId;

}
