package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 12:19 2018/3/26
 * @Modified By
 */
@Data
@ApiModel(value = "LoginInfoVO", description = "APP端登陆信息")
public class LoginInfoVO {

    @ApiModelProperty(value = "用户账号")
    @NotBlank
    private String account;

    @ApiModelProperty(value = "用户密码")
    @NotBlank
    private String password;

    @ApiModelProperty(value = "是否验证")
    private String isChecked;

    @ApiModelProperty(value = "用户密码,不传默认就是微信登陆【2】。1为pc；2为app；3为微信; 4小程序")
    private Integer terminalType;

    @ApiModelProperty("密码加密盐")
    private String salt;

    @ApiModelProperty("签名")
    private String sign;

    @ApiModelProperty("语种code")
    private String languageCode;

    @ApiModelProperty(value = "图形验证码Key")
    private String captchaKey;

    @ApiModelProperty(value = "图形验证码")
    private String captchaVal;
}
