package com.yizhi.system.application.vo;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "OrgExportVO", description = "导出组织架构信息")
public class OrgExportVO {

    /**
     * 部门id
     */
    @ApiModelProperty(value = "部门id")
    private Long orgId;

    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码")
    private String orgCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称")
    private String orgName;

    /**
     * 总用户数
     */
    @ApiModelProperty(value = "总用户数")
    private Long userSumNum;

    /**
     * 总启用用户数
     */
    @ApiModelProperty(value = "总启用用户数")
    private Long enableUserNum;

    /**
     * 总停用用户数
     */
    @ApiModelProperty(value = "总停用用户数")
    private Long stopUserNum;

    /**
     * 直属部门id
     */
    @ApiModelProperty(value = "直属部门id")
    private Long parentId;
    
    /**
     * 直属部门编码
     */
    @ApiModelProperty(value = "直属部门编码")
    private String parentCode;
    
    /**
     * 直属部门名称
     */
    @ApiModelProperty(value = "直属部门名称")
    private String parentName;
    
    /**
     * 上级部门
     */
    @ApiModelProperty(value = "上级部门")
    private String upName;
    
    /**
     * 当前用户状态 0 正常；1：未开启；
     */
    @ApiModelProperty(value = "当前用户状态 0 正常；1：未开启；")
    private String status;
}
