package com.yizhi.system.application.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * 外部用户信息
 */
@Api(tags = "OutsideUserVO",value = "外部接入的用户信息")
@Data
public class OutsideUserVO {

    private Long id;

    @ApiModelProperty(value = "接入用户的唯一名")
    private String name;

    @ApiModelProperty(value = "用户的昵称或者名字")
    private String fullName;

    // 存放再用户的RemarkFirst字段
    @ApiModelProperty(value = "用户的对接状态：0 待入职；1 在职； 2离职")
    private String status;

    @ApiModelProperty(value = "用户所在的组织层级")
    private String orgNames;

    private Long orgId;

    @ApiModelProperty(value = "邮箱地址")
    private String email;

    @ApiModelProperty(value = "手机号码")
    private String mobile;

    @ApiModelProperty(value = "工号")
    private String workNum;

    @ApiModelProperty(value = "性别（M：男，F:女）")
    private String sex;

    @ApiModelProperty(value = "职位")
    private String position;

    @ApiModelProperty(value = "身份证号")
    private String idNumber;

    // 存放再用户的RemarkSecond字段
    private Long siteId;

    @Override
    public String toString() {
        return "OutsideUserVO{" +
                "name='" + StringUtils.trimToEmpty(name) + '\'' +
                ", fullName='" + StringUtils.trimToEmpty(fullName) + '\'' +
                ", password='" + StringUtils.trimToEmpty(status) + '\'' +
                ", orgNames='" + orgId==null?"":orgId.toString() + '\'' +
                ", email='" + StringUtils.trimToEmpty(email) + '\'' +
                ", mobile='" + StringUtils.trimToEmpty(mobile) + '\'' +
                ", workNum='" + StringUtils.trimToEmpty(workNum) + '\'' +
                ", sex='" + StringUtils.trimToEmpty(sex) + '\'' +
                ", position='" + StringUtils.trimToEmpty(position) + '\'' +
                ", idNumber='" + StringUtils.trimToEmpty(idNumber) + '\'' +
                '}';
    }
}
