package com.yizhi.system.application.vo;

import org.hibernate.validator.constraints.NotBlank;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 账号VO类
 *
 */
@ApiModel(value = "PageRoleVO", description = "分页角色业务属性封装")
@Data
public class PageRoleVO{

	@ApiModelProperty(value = "角色信息唯一ID，新增时候不用传")
	private Long id;

	@ApiModelProperty(value = "角色名")
	@NotBlank
	private String name;

	@ApiModelProperty(value = "角色序号")
	@NotBlank
	private String code;

	@ApiModelProperty(value = "是否开通,1为开通，0为不开通")
	private Boolean enabled;

	@ApiModelProperty(value = "当前页")
	private Integer pageNo=1;
	    
    @ApiModelProperty(value = "每页数")
	private Integer pageSize=10;

}