package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

@Data
@ApiModel("站点维护详情")
public class SiteProtectDetailVO {

    @ApiModelProperty(value = "维护名称",name = "name")
    private String name;

    @ApiModelProperty(value = "维护主体id",name = "id")
    private String id;


    @ApiModelProperty(value = "关站提示标识")
    private Boolean closeFlag;

    @ApiModelProperty(value = "站内通知标识")
    private Boolean innerFlag;

    @ApiModelProperty(value = "通知方式列表")
    private List<NoticeVO> noticeVOList;

    @ApiModelProperty("站点信息列表")
    private List<SiteCompanyVO> siteCompanyS;

    public Long getId() {
        return StringUtils.isBlank(id)?null:Long.parseLong(id);
    }
}
