package com.yizhi.system.application.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 11:34 2018/12/5
 * @Modified By
 */
@Data
@Api(tags = "SmsReturnReceiptVO", description = "短信回执信息")
public class SmsReturnReceiptVO {

    @ApiModelProperty(value = "bizId", notes = "发送流水号,从调用发送接口返回值中获取")
    private String bizId;

    @ApiModelProperty(value = "phoneNum", notes = "手机号码")
    private String phoneNum;

    @ApiModelProperty(value = "sendStatus", notes = "发送状态 1：等待回执，2：发送失败，3：发送成功")
    private Long sendStatus;

    @ApiModelProperty(value = "errCode", notes = "运营商短信错误码")
    private String errCode;

    @ApiModelProperty(value = "templateCode", notes = "模板ID")
    private String templateCode;

    @ApiModelProperty(value = "templateParam", notes = "模板参数 :格式{\"code\":\"verifyCode\"}")
    private String templateParam;

    @ApiModelProperty(value = "templateType", notes = "模版类型:{验证码" +
            "sms.type.verification.code ;短信通知 sms.type.notice ;推广短信 sms.type.popularize}")
    private String templateType;

    @ApiModelProperty(value = "content", notes = "短信内容")
    private String content;

    @ApiModelProperty(value = "sendDate", notes = "发送时间 :格式2017-05-25 00:00:00")
    private String sendDate;

    @ApiModelProperty(value = "receiveDate", notes = "接收时间 :格式2017-05-25 00:00:00")
    private String receiveDate;

    @ApiModelProperty(value = "outId", notes = "外部流水扩展字段")
    private String outId;

    @ApiModelProperty(value = "smsUpExtendCode", notes = "上行短信扩展码,无特殊需要此字段的用户请忽略此字段")
    private String smsUpExtendCode;

    @ApiModelProperty(value = "bizType", notes = "发送短信的业务类型：first.login.sms.biz.type 首次登陆短信，" +
            "forget.pwd.sms.biz.type 忘记密码短信；mobile.login.sms.biz.type 手机号登陆短信")
    private String bizType;

    @ApiModelProperty(value = "companyId", notes = "企业id")
    private Long companyId;

    @ApiModelProperty(value = "siteId", notes = "站点Id")
    private Long siteId;

    @ApiModelProperty(value = "businesslogo", notes = "业务标识（登陆存用id,考试存考试的id......其他业务类似）")
    private Long businesslogo;


}
