package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 12:19 2018/3/26
 * @Modified By
 */
@Data
@ApiModel(value = "WechatLoginInfoVO", description = "微信端端登陆信息")
public class WechatLoginInfoVO {

    @ApiModelProperty(value = "用户账号")
    @NotBlank
    private String account;

    @ApiModelProperty(value = "用户密码")
    @NotBlank
    private String password;

    @ApiModelProperty(value = "微信登陆需要传递openId")
    private String openId;

    @ApiModelProperty(value = "用户密码,不传默认就是微信登陆【3】。1为pc；2为app；3为微信; 4小程序，5 绑定开放平台")
    private Integer terminalType;

    @ApiModelProperty(value = "小程序的用户头像")
    private String image;
    
    @ApiModelProperty("密码加密盐")
    private String salt;

    @ApiModelProperty("签名")
    private String sign;

    @ApiModelProperty("语种code")
    private String languageCode;
}
