package com.yizhi.system.application.vo.domain;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 组活动关联用户
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-04-16
 */
@Data
@Api(tags = "AuthzGroupMember", description = "后台管辖区关联范围，逻辑删除")
public class AuthzGroupMember{

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "管辖区id")
    private Long groupId;

    @ApiModelProperty(value = "关联成员id，类型由type决定（1:部门2:用户）")
    private Long memberId;

    @ApiModelProperty(value = "成员类型(1:部门2:用户)")
    private Integer type;

    @ApiModelProperty(value = "创建者id")
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "逻辑删除  1:代表已删除 0：未删除  数据库默认为0")
    private Integer deleted;

	public AuthzGroupMember() {
		super();
	}

	public AuthzGroupMember(Long id, Long groupId, Long memberId, Integer type) {
		super();
		this.id = id;
		this.groupId = groupId;
		this.memberId = memberId;
		this.type = type;
	}
    
}
