package com.yizhi.system.application.vo.domain;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 角色表
 * </p>
 *
 * @author 谢海军123
 * @since 2018-03-12
 */
@Data
@Api(tags = "Role", description = "角色表")
public class AuthzRole  {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "角色id")
    private Long id;

    @ApiModelProperty(value = "编码")
    private String code;

    @ApiModelProperty(value = "角色名称")
    private String name;

    @ApiModelProperty(value = "是否启用：0否，1是；默认1")
    private Integer enabled;

    @ApiModelProperty(value = "角色描述")
    private String description;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "公司id(内置角色，值为0)")
    private Long companyId;

    @ApiModelProperty(value = "创建者id")
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

    @ApiModelProperty(value = "关联用户数，不持久化")
    private Integer relevanceNum;
    
    @ApiModelProperty(value = "模块id列表")
    private List<Long> menuIds;
    
    @ApiModelProperty(value = "管辖区id列表")
    private List<Long> groupIds;

    @ApiModelProperty(value = "被管理的管理员的用户 id集合")
    private List<Long> managerAccountIds;

    @ApiModelProperty(value = "被管理的管理员的用户名")
    private String managerAccountNames = "";



}
