package com.yizhi.system.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 登陆统计（天）
 * </p>
 *
 * @author shengchenglong123
 * @since 2019-10-11
 */
@Data
@Api(tags = "DaIndicatorLoginDay", description = "登陆统计（天）")
public class DaIndicatorLoginDay  {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "登陆人数")
    private Integer personNum;

    @ApiModelProperty(value = "pc登陆人数")
    private Integer pcPersonNum;

    @ApiModelProperty(value = "移动登陆人数")
    private Integer mobilePersonNum;

    @ApiModelProperty(value = "既登陆pc，又登录移动 人数")
    private Integer mixPersonNum;

    @ApiModelProperty(value = "登陆人次")
    private Integer personTime;

    @ApiModelProperty(value = "pc登陆人次")
    private Integer pcPersonTime;

    @ApiModelProperty(value = "移动登陆人次")
    private Integer mobilePersonTime;

    @ApiModelProperty(value = "既登陆pc，又登录移动 人次")
    private Integer mixPersonTime;

    @ApiModelProperty(value = "时间（天）")
    private Date day;

    @ApiModelProperty(value = "处理时间")
    private Date processTime;



}
