package com.yizhi.system.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(value = "LanguageClassify", description = "语种")
@Data
public class LanguageClassify {

    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "主键id")
    private Long id;
    
    @ApiModelProperty(value = "语种名称")
    private String name;
    
    @ApiModelProperty(value = "语种编码")
    private String code;
    
    @ApiModelProperty(value = "语种logo")
    private String logo;
    
    @ApiModelProperty(value = "语种描述")
    private String description;
    
    @ApiModelProperty(value = "语种显示状态 0显示 1隐藏 默认显示")
    private Integer state;
    
    @ApiModelProperty(value = "是否删除 0否 1是")
    private Integer deleted;
    
    @ApiModelProperty(value = "排序字段")
    private Integer sort;
    
    @ApiModelProperty(value = "创建者id")
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

}
