package com.yizhi.system.application.vo.domain;

import java.util.Date;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 短信发送以后状态的回馈信息
 * </p>
 *
 * @author 谢海军123
 * @since 2018-12-06
 */
@Data
@ApiModel(value = "SmsReturnReceip", description = "短信发送以后状态的回馈信息")
public class SmsReturnReceip {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "唯一编码")
	private Long id;

    @ApiModelProperty(value = "发送短信的记录id")
	private String sendRecordId;

    @ApiModelProperty(value = "发送状态 1：等待回执，2：发送失败，3：发送成功")
	private Integer sendStatus;

    @ApiModelProperty(value = "运营商短信错误码")
	private String errCode;

    @ApiModelProperty(value = "手机号码(如果是批量发送，关联手机号批量发送表的id)")
	private String phoneNum;

    @ApiModelProperty(value = "模板ID")
	private String templateCode;

    @ApiModelProperty(value = "发送的短信内容")
	private String content;

    @ApiModelProperty(value = "发送时间 :格式2017-05-25 00:00:00")
	private Date sendDate;

    @ApiModelProperty(value = "接收时间 :格式2017-05-25 00:00:00")
	private Date receiveDate;

    @ApiModelProperty(value = "外部流水扩展字段")
	private String outId;

    @ApiModelProperty(value = "创建时间")
	private Date createTime;



}
