package com.yizhi.system.application.vo.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 短信发送记录表
 * </p>
 *
 * @author 谢海军123
 * @since 2018-12-06
 */
@Data
@ApiModel(value = "SmsSendRecord", description = "短信发送记录表")
public class SmsSendRecord {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "唯一编码")
	private Long id;

    @ApiModelProperty(value = "发送流水号,从调用发送接口返回值中获取")
	private String bizId;

    @ApiModelProperty(value = "手机号码(如果是批量发送，关联手机号批量发送表的id)")
	private Long phoneNum;

    @ApiModelProperty(value = "模板ID")
	private String templateCode;

    @ApiModelProperty(value = "模板参数 :格式{\"code\":\"verifyCode\"}")
	private String templateParam;

	@ApiModelProperty(value = "发送短信的业务类型：first.login.sms.biz.type 首次登陆短信，forget.pwd.sms.biz.type 忘记密码短信；mobile.login.sms.biz.type 手机号登陆短信;update.mobile.sms.biz.type 修改手机号")
	private String templateType;

    @ApiModelProperty(value = "外部流水扩展字段")
	private String outId;

    @ApiModelProperty(value = "上行短信扩展码,无特殊需要此字段的用户请忽略此字段")
	private String smsUpExtendCode;

    @ApiModelProperty(value = "发送短信的业务类型：first.login.sms.biz.type 首次登陆短信，forget.pwd.sms.biz.type 忘记密码短信；mobile.login.sms.biz.type 手机号登陆短信")
	private String bizType;

    @ApiModelProperty(value = "企业id")
	private Long companyId;

    @ApiModelProperty(value = "站点Id")
	private Long siteId;

    @ApiModelProperty(value = "业务标识（登陆存用id,考试存考试的id......其他业务类似）")
	private Long businessLogo;

    @ApiModelProperty(value = "数据创建时间")
	private Date createDate;

    @ApiModelProperty(value = "短信签名")
	private String signName;

    @ApiModelProperty(value = "数据更新时间")
	private Date updateTime;

    @ApiModelProperty(value = "发送类型：simple.send.sms 单次发送；batch.send.sms 批量发送")
	private String sendType;

	@ApiModelProperty(value = "扩展字段，一些特殊业务使用")
	private String extend;



}
