package com.yizhi.system.application.vo.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 学员修改资料权限
 * </p>
 *
 * @author 谢海军123
 * @since 2019-03-07
 */
@Data
@ApiModel(value = "StudentEditPermission", description = "学员修改资料权限")
public class StudentEditPermission {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "唯一主键")
	private Long id;

    @ApiModelProperty(value = "配置所属的企业")
	private Long companyId;

    @ApiModelProperty(value = "配置所属的站点")
	private Long siteId;

    @ApiModelProperty(value = "是否允许该站点学员是否可修改自己的姓名字段 0(false):不允许；1(true)：允许")
	private Boolean nameEditPermission;

    @ApiModelProperty(value = "是否允许该站点学员是否可修改自己的职务字段 0(false):不允许；1(true)：允许")
	private Boolean positionEditPermission;

    @ApiModelProperty(value = "是否允许该站点学员是否可修改自己的手机号码字段 0(false):不允许；1(true)：允许")
	private Boolean mobileEditPermission;

    @ApiModelProperty(value = "是否允许该站点学员是否可修改自己的邮箱字段 0(false):不允许；1(true)：允许")
	private Boolean emailEditPermission;

    @ApiModelProperty(value = "是否允许该站点学员是否可修改自己的个人简介字段 0(false):不允许；1(true)：允许")
	private Boolean synopsisEditPermission;

    @ApiModelProperty(value = "创建人id")
	private Long createById;

    @ApiModelProperty(value = "创建时间")
	private Date createTime;

    @ApiModelProperty(value = "更新人")
	private Long updateById;

    @ApiModelProperty(value = "更新时间")
	private Date updateTime;

	@ApiModelProperty(value = "修改者名称")
	private String updateByName;

	@ApiModelProperty(value = "创建者名称")
	private String createByName;

}
