package com.yizhi.system.application;

import java.util.Properties;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 15:48 2018/4/2
 * @Modified By
 */
@Component
public class KaptchaConfig {


    @Value("${kaptcha.textproducer.char.length}")
    private String textLength;

    @Value("${kaptcha.image.width}")
    private String width;

    @Value("${kaptcha.image.height}")
    private String height;

    @Bean
    public DefaultKaptcha getDefaultKaptcha(){
        com.google.code.kaptcha.impl.DefaultKaptcha defaultKaptcha = new com.google.code.kaptcha.impl.DefaultKaptcha();
        Properties properties = new Properties();
        properties.put("kaptcha.textproducer.char.length",textLength);
        properties.put("kaptcha.image.width",width);
        properties.put("kaptcha.image.height",height);
        properties.put("kaptcha.textproducer.font.color","69,139,0");
        properties.put("kaptcha.noise.color","255,130,71");
        properties.put("kaptcha.background.clear.from","white");
        properties.put("kaptcha.background.clear.to","white");
        Config config = new Config(properties);
        defaultKaptcha.setConfig(config);

        return defaultKaptcha;
    }
}
