package com.yizhi.system.application.controller.api;
/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 11:59 2018/3/21
 * @Modified By
 */

import com.alibaba.fastjson.JSON;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.yizhi.calendar.application.feign.CalendarClient;
import com.yizhi.calendar.application.vo.CalendarVO;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.enums.SmsSendBizType;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.core.application.token.TokenHelper;
import com.yizhi.point.application.feign.PointListenerClients;
import com.yizhi.point.application.feign.PointRedisFeignClients;
import com.yizhi.site.application.enums.FunctionTypeCode;
import com.yizhi.site.application.feign.api.EventTrackApiClients;
import com.yizhi.site.application.feign.api.FunctionDisplayConfigApiClients;
import com.yizhi.site.application.feign.api.MyItemConfigApiClients;
import com.yizhi.site.application.feign.api.MyItemConfigDefaultApiClients;
import com.yizhi.site.application.vo.domain.FunctionDisplayConfigVo;
import com.yizhi.site.application.vo.site.MyItemConfigVO;
import com.yizhi.system.application.constant.SecurityError;
import com.yizhi.system.application.controller.manage.AccountController;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.AuthzAccountRole;
import com.yizhi.system.application.domain.AuthzRole;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.enums.SecurityReturnCode;
import com.yizhi.system.application.exception.AuthNoManagementException;
import com.yizhi.system.application.exception.AuthNotManageException;
import com.yizhi.system.application.model.AccessSite;
import com.yizhi.system.application.service.*;
import com.yizhi.system.application.util.LanguageUtil;
import com.yizhi.system.application.util.SignUtil;
import com.yizhi.system.application.vo.*;
import com.yizhi.util.application.constant.GlobalConstant;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.date.DateUtil;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.encrypt.ShaEncrypt;
import com.yizhi.util.application.enums.i18n.Constants;
import com.yizhi.util.application.sm2.SM2_NEW;
import com.yizhi.util.application.validation.ValidUtil;
import com.yizhi.wechat.application.feign.WeiXinClient;
import com.yizhi.wechat.application.vo.wechat.TrAccountUserinfoVO;
import com.yizhi.wechat.application.vo.wechat.domain.TrAccountUserinfoVo;
import io.jsonwebtoken.Claims;
import io.swagger.annotations.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Api(tags = "认证接口")
@RestController
@RequestMapping(value = "/api")
public class AuthController {

    @Autowired
    IAccountService accountService;
    @Autowired
    IAuthzRoleService roleService;
    @Autowired
    IAuthzResourceService resourceService;
    @Autowired
    TokenHelper tokenHelper;
    @Autowired
    private WeiXinClient weiXinClient;
    @Autowired
    private ILoginLogService loginLogService;
    @Autowired
    private AuthService authService;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private ICompanyService iCompanyService;
    @Autowired
    private ISiteService siteService;
    @Autowired
    private FunctionDisplayConfigApiClients functionClient;
    @Autowired
    private MyItemConfigApiClients myItemConfigApiClients;
    @Autowired
    private MyItemConfigDefaultApiClients myItemConfigDefaultApiClients;
    @Autowired
    private CalendarClient calendarClient;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private IOrganizationService iOrganizationService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private LanguageUtil languageUtil;
    @Autowired
    private IFirstLoginLogService firstLoginLogService;
    @Autowired
    private AccountController accountController;

//    @Autowired
//    private PointListenerClients pointListenerClients;

    @Autowired
    private PointRedisFeignClients pointRedisFeignClients;

    @Autowired
    private EventTrackApiClients eventTrackApiClients;

    @Autowired
    private IAuthzAccountRoleService authzAccountRoleService;


    private static final Logger logger = LoggerFactory.getLogger(AuthController.class);
    private static final String LOGIN_PASSWORD_ERROR_RECORD = "login:password:err:times:";
    private static final Long ERROR_LOCK_TIME = 300L;
    private static final Integer ERROR_MAX_LOCK_TIMES = 5;

    private static final Integer PC = 1;
    private static final Integer APP = 2;
    private static final Integer MANAGE = 9;
    private static final Integer WECHAT = 3;

    @ApiOperation(value = "手机短信登陆", notes = "手机短信登陆")
    @GetMapping(value = "/loginSms")
    public Response<String> loginSms(HttpServletResponse httpResponse,
                                     @ApiParam(required = true, value = "短信验证码") @RequestParam("smsVerifyCode") String smsVerifyCode,
                                     @ApiParam(required = true, value = "手机号") @RequestParam("mobile") Long mobile,
                                     @ApiParam(required = true, value = "短信发送成功返回的业务流水号") @RequestParam("smsSendRequestNo") String smsSendRequestNo,
                                     @ApiParam(required = false, value = "终端类型,传3表示微信，其他表示pc") @RequestParam(value = "terminalType", required = false) Integer terminalType,
                                     @ApiParam(required = false, value = "语种code") @RequestParam(value = "languageCode", required = false) String languageCode) {

        if (mobile == null) {
            // 手机号为空
            return Response.fail(Constants.SYSTEM_MSG_MOBILE_NUMBER_EMPTY);
        }
        RequestContext context = ContextHolder.get();
        Map<String, Object> retMap = new HashMap<>();
        try {
            // 检查手机是否绑定账号
            com.yizhi.system.application.domain.Account user = accountService.mobileBindCheck(mobile);
            // 检查账号是否过期失效
            Response<String> x = checkAccountExpired(user);
            if (x != null) {
                return x;
            }
            // 检查验证码是否有效
            accountService.checkVerifyCode(SmsSendBizType.MOBILE_LOGIN, mobile, smsVerifyCode, smsSendRequestNo);
            //创建token
            String token = createToken(user, context);
            //设置用户信息
            setUserInfo(user, context, httpResponse, retMap, token);
            //设置签到弹框
            setEnableSign(retMap, user, context);
            //添加登录记录
            addLoginRecord(user.getId(), user.getCompanyId(), context.getSiteId(), user.getOrgId(), terminalType == null ? 1 : terminalType);
            //设置最后一次登录站点信息
            setStudentLastLoginRecordCache(user.getId(), context);
            //登录成功，设置用户选择的语言
            languageUtil.setStudentSelectLanguage(context, languageCode);

        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
        return Response.ok(retMap);
    }


    /**
     * 创建token
     *
     * @param user
     * @param context
     * @return
     */
    private String createToken(Account user, RequestContext context) {
        Map<String, Object> info = new HashMap<>();
        info.put(GlobalConstant.ACCOUNT_ID, user.getId().toString());
        info.put(GlobalConstant.COMPANY_CODE, context.getCompanyCode());
        info.put(GlobalConstant.COMPANY_ID, context.getCompanyId().toString());
        info.put(GlobalConstant.COMPANY_NAME, context.getCompanyName());
        info.put(GlobalConstant.SITE_ID, context.getSiteId().toString());
        info.put("context", JSON.toJSONString(context));//社群需要
        String token = "";
        try {
            token = tokenHelper.createToken(user.getName(), info);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("创建token发生异常");
            throw new BizException("40001", "创建token发生异常");
        }
        return token;
    }

    /**
     * 设置用户返回信息
     *
     * @param user
     * @param context
     * @param httpResponse
     * @param retMap
     * @throws Exception
     */
    private void setUserInfo(Account user, RequestContext context, HttpServletResponse httpResponse, Map<String, Object> retMap, String token) {
        context.setAccountId(user.getId());
        context.setOrgId(user.getOrgId());
        httpResponse.addHeader(GlobalConstant.TOKEN_HEADER, token);
        // 返回token信息
        retMap.put(GlobalConstant.TOKEN_HEADER, token);
        // 返回用户信息
        user.setPassword("");
        retMap.put("userInfo", user);
        retMap.put("siteId", context.getSiteId().toString());
        retMap.put("siteCode", context.getSiteCode());
    }

    /**
     * 设置用户返回信息
     *
     * @param retMap
     * @param user
     * @param token
     * @param context
     */
    private void setRetMap(Map<String, Object> retMap, Account user, String token, RequestContext context) {
        // 返回token信息
        //retMap.put(GlobalConstant.TOKEN_HEADER, token);
        // 返回用户信息
        user.setPassword("");
        retMap.put("userInfo", user);
        retMap.put("siteId", context.getSiteId().toString());
    }

    /**
     * 设置登录后弹出签到
     *
     * @param retMap
     * @param user
     * @param context
     */
    private void setEnableSign(Map<String, Object> retMap, Account user, RequestContext context) {
        try {
            retMap.putAll(isEnableSign(context.getSiteId(), user.getId()));
        } catch (Exception e) {
            logger.error("服务异常", e);
            retMap.put("isEnableSign", 0);
        }

    }

    /**
     * 添加角色信息
     *
     * @param retMap
     * @param user
     */
    private void setAuthInfo(Map<String, Object> retMap, Account user) {
        List<AuthzRole> roles = authService.getByAccountId(user.getId());
        retMap.put("authList", roles);
    }

    @ApiOperation(value = "用户登录", notes = "用户登录", extensions = {
            @Extension(name = ReturnCode.API_SUB_FLAG, properties = {
                    @ExtensionProperty(name = SecurityError.LOGIN_INFO_ERROR, value = SecurityError.LOGIN_INFO_ERROR_MSG)})})
    @RequestMapping(value = "/login", method = RequestMethod.POST)
    public Response<String> login(HttpServletRequest request, HttpServletResponse httpResponse,
                                  @ApiParam(required = true, value = "用户账号") @RequestParam(required = true) String account,
                                  @ApiParam(required = true, value = "用户密码") @RequestParam(required = true) String password,
                                  @ApiParam(required = true, value = "是否需要做首次登陆") @RequestParam(required = true, defaultValue = "false") Boolean firstLoginFlg,
                                  @ApiParam(required = false, value = "语种code") @RequestParam(value = "languageCode", required = false) String languageCode,
                                  @RequestParam(value = "terminalType") Integer terminalType) {
        try {
            logger.info("登陆处理开始");
            RequestContext context = ContextHolder.get();
            com.yizhi.system.application.domain.Account user = accountService.find(context.getCompanyId(), account);

            if (user == null) {
                return Response.fail(Constants.SYSTEM_MSG_ACCOUNT_NOT_EXIST);
            }
            String accountId = String.valueOf(user.getId());
            //检查是否密码错误次数过多，已锁定
            try {
                checkPasswordTimes(accountId, password, user.getPassword());
            } catch (BizException e) {
                return Response.fail(e.getCode(), e.getMsg());
            }
            Response<String> x = checkAccountExpired(user);
            if (x != null) {
                return x;
            }
            Map<String, Object> retMap = new HashMap<>();
            Boolean firstLogin = user.getFirstLogin();
            if (firstLogin == null) {
                firstLogin = true;
            }
            context.setAccountId(user.getId());
            context.setOrgId(user.getOrgId());
            Long siteId = accountService.findSiteId(user.getId());
            if (siteId != null) {
                context.setSiteId(siteId);
                Site site = siteService.findById(siteId);
                if (site != null) {
                    context.setSiteCode(site.getCode());
                }
            }
            String token = createToken(user, context);
            // 生成token(不是首次登陆)
            if (!firstLoginFlg) {
                //设置用户信息
                setUserInfo(user, context, httpResponse, retMap, token);
            } else {
                if (!firstLogin) {
                    //设置用户信息
                    setUserInfo(user, context, httpResponse, retMap, token);
                }
            }
            setRetMap(retMap, user, token, context);
            //设置签到弹框
            setEnableSign(retMap, user, context);
            // 添加角色
            setAuthInfo(retMap, user);
            httpResponse.addHeader(GlobalConstant.TOKEN_HEADER, token);
            //设置最后一次登录站点信息
            setStudentLastLoginRecordCache(user.getId(), context);
            //登录成功，设置用户选择的语言
            languageUtil.setStudentSelectLanguage(context, languageCode);

            if (Objects.equals(terminalType, APP)) {
                context.setSiteType(terminalType);
                // 新增登录积分
                String shortDay = DateUtil.toShortDay(new Date());
                if (!redisCache.hasKey(request.getSession().getId())) {
                    //pointRedisFeignClients.pointAdd("point_login", user.getId(), null);
                    // 添加登录埋点
                    eventTrackApiClients.addEvent("event_login", context.getAccountId());
                    logger.info("=================登录session，{}", request.getSession().getId());
                    redisCache.set(request.getSession().getId(), String.valueOf(terminalType), 86400);
                }
            }
            ContextHolder.set(context);
            logger.info("登陆处理结束");
            return Response.ok(retMap);

        } catch (Exception e) {
            logger.error("", e);
            return Response.fail();
        }
    }


    /**
     * 验证签名
     *
     * @param user
     * @return
     */
    private Response checkSign(LoginInfoVO user) {
        //验签
        SortedMap<String, String> map = new TreeMap<String, String>();
        map.put("account", user.getAccount());
        map.put("password", user.getPassword());
        map.put("salt", user.getSalt());
        map.put("sign", user.getSign());
        boolean result = SignUtil.isCorrectSign(map, user.getSalt());
        if (!result) {
            //临时注释
//            return Response.fail("4000", "非法登录", "");
        }
        String sign = (String) redisCache.get(user.getSign());
        if (StringUtils.isNotBlank(sign)) {
            return Response.fail(ReturnCode.DUPLICATE_REQUEST.getCode(), ReturnCode.DUPLICATE_REQUEST.getMsg());
        } else {
            redisCache.set(user.getSign(), "1", 86400);
        }
        return null;
    }

    /**
     * 检查用户的密码是否错误次数过多导致锁定
     *
     * @param accountId
     * @param inputPassword
     * @param userPassword
     */
    private void checkPasswordTimes(String accountId, String inputPassword, String userPassword) {
        // 查看之前是否有过密码错误
        String key = LOGIN_PASSWORD_ERROR_RECORD + accountId;
        Object passwordErrTimes = redisCache.get(key);
        try {
            if (passwordErrTimes != null) {
                if (Integer.parseInt(passwordErrTimes.toString()) > 5) {
                    logger.info("--------------------------------passwordErrTimes : " + passwordErrTimes.toString());
                    throw new BizException(Constants.SYSTEM_MSG_PWD_ERROR.getCode().toString(), Constants.SYSTEM_MSG_PWD_ERROR.getName());
                }
            }
            if (!ShaEncrypt.comparePassword(inputPassword, userPassword)) {
                logger.info("用户密码错误，加密密码=" + userPassword + "输入密码=" + inputPassword);
                Integer times = 1;
                if (passwordErrTimes != null) {
                    times = Integer.parseInt(passwordErrTimes.toString()) + 1;
                }
                logger.info("--------------------------------times : " + times);
                redisCache.set(key, String.valueOf(times), ERROR_LOCK_TIME);
                returnErrorTitle(times);
            }
        } catch (BizException e) {
            throw new BizException(e.getCode(), e.getMsg());
        }
        redisCache.delete(key);
    }

    /**
     * 获取不同错误次数的错误提示
     *
     * @param errorTimes
     */
    private void returnErrorTitle(Integer errorTimes) {
        switch (errorTimes) {
            case 1:
                throw new BizException(Constants.SYSTEM_MSG_PWD_ERROR1.getCode().toString(), Constants.SYSTEM_MSG_PWD_ERROR1.getName());
            case 2:
                throw new BizException(Constants.SYSTEM_MSG_PWD_ERROR2.getCode().toString(), Constants.SYSTEM_MSG_PWD_ERROR2.getName());
            case 3:
                throw new BizException(Constants.SYSTEM_MSG_PWD_ERROR3.getCode().toString(), Constants.SYSTEM_MSG_PWD_ERROR3.getName());
            case 4:
                throw new BizException(Constants.SYSTEM_MSG_PWD_ERROR4.getCode().toString(), Constants.SYSTEM_MSG_PWD_ERROR4.getName());
            case 5:
                throw new BizException(Constants.SYSTEM_MSG_PWD_ERROR5.getCode().toString(), Constants.SYSTEM_MSG_PWD_ERROR5.getName());
            default:
                throw new BizException(Constants.SYSTEM_MSG_PWD_ERROR.getCode().toString(), Constants.SYSTEM_MSG_PWD_ERROR.getName());
        }
    }

    /**
     * 用户是否被锁定或者过期时效
     *
     * @param user
     * @return
     */
    private Response<String> checkAccountExpired(com.yizhi.system.application.domain.Account user) {
        if (!user.getEnabled() || user.getLocked()) {
            // 账号未启用或者锁定
            return Response.fail(Constants.SYSTEM_MSG_ACCOUNT_DISABLE_OR_LOCKD.getCode().toString(),
                    Constants.SYSTEM_MSG_ACCOUNT_DISABLE_OR_LOCKD.getName());
            // 前面时间大于后面时间==1
        } else if (user.getExpiredType() == 2 && user.getEndTime().compareTo(new Date()) <= 0) {
            // 账号已过期
            return Response.fail(Constants.SYSTEM_MSG_ACCOUNT_EXPIRED.getCode().toString(),
                    Constants.SYSTEM_MSG_ACCOUNT_EXPIRED.getName());
        } else if (user.getExpiredType() == 3 && user.getExpiredTime().compareTo(new Date()) <= 0) {
            return Response.fail(Constants.SYSTEM_MSG_ACCOUNT_EXPIRED.getCode().toString(),
                    Constants.SYSTEM_MSG_ACCOUNT_EXPIRED.getName());
        }
        return null;
    }

    @ApiOperation(value = "手机APP端用户登录", notes = "手机APP端用户登录", extensions = {
            @Extension(name = ReturnCode.API_SUB_FLAG, properties = {
                    @ExtensionProperty(name = SecurityError.LOGIN_INFO_ERROR, value = SecurityError.LOGIN_INFO_ERROR_MSG)})})
    @RequestMapping(value = "/loginApp", produces = {"application/json;charset=utf-8"}, method = RequestMethod.POST)
    public Response<String> loginApp(HttpServletRequest request, HttpServletResponse httpResponse,
                                     @ApiParam(name = "user") @RequestBody @Valid LoginInfoVO user, BindingResult validResults) {
        try {
            boolean flag = accountService.validateCaptcha(user.getCaptchaKey(), user.getCaptchaVal());                                              //图形码验证
        } catch (BizException e) {
            logger.warn("验证码校验错误：{}" + e);
            return Response.fail(e.getCode(), e.getMsg());
        }
        if (validResults.hasFieldErrors()) {
            String error = ValidUtil.convertParamError(validResults.getFieldErrors());
            logger.warn("参数校验错误：{}" + error);
            return Response.fail(Constants.MSG_REQUEST_ERROR);
        }
        if (StringUtils.isBlank(user.getSalt()) || StringUtils.isBlank(user.getSign())) {
            return Response.fail("4000", InternationalEnums.AUTHCONTROLLER1.getCode(), "");
        }
        String passWord = user.getPassword();
        String accountName = user.getAccount();
        if (StringUtils.isNotBlank(user.getSign()) && StringUtils.isNotBlank(user.getSalt())) {
            //验证签名
            Response response = checkSign(user);
            if (response != null) {
                return response;
            }
            //SM2还原密码
            passWord = SM2_NEW.decryptWithSalt(user.getPassword());
            if (null == passWord) {
                return Response.fail(Constants.SYSTEM_MSG_ACCOUNT_PWD_ERROR.getName());
            }
            accountName = SM2_NEW.decryptWithSalt(user.getAccount());
            if (null == accountName) {
                return Response.fail(Constants.SYSTEM_MSG_ACCOUNT_PWD_ERROR.getName());
            }
        }
        Response<String> ret = login(request, httpResponse, accountName, passWord, false, user.getLanguageCode(), APP);
        RequestContext context = ContextHolder.get();
        if (ReturnCode.SUCCESS.getCode().equals(ret.getCode())) {
            logger.info("手机APP端用户登录上下文=" + JSON.toJSONString(ContextHolder.get()));
            boolean isAccessToSite = isAccessToSite(context.getAccountId(), context.getSiteId(), context.getCompanyId(), context.getCompanyCode(), false);
            if (!isAccessToSite) {
                return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH);
            }
            if ("true".equals(user.getIsChecked())) {
                return ret;
            }
            Integer terminalType = user.getTerminalType() == null ? APP : user.getTerminalType();
            //添加登录日志
            addLoginRecord(context.getAccountId(), context.getCompanyId(), context.getSiteId(), context.getOrgId(), terminalType);
        }
        return ret;
    }

    @ApiOperation(value = "学员pc端用户登录", notes = "学员pc端用户登录", extensions = {
            @Extension(name = ReturnCode.API_SUB_FLAG, properties = {
                    @ExtensionProperty(name = SecurityError.LOGIN_INFO_ERROR, value = SecurityError.LOGIN_INFO_ERROR_MSG)})})
    @RequestMapping(value = "/loginPc", produces = {"application/json;charset=utf-8"}, method = RequestMethod.POST)
    public Response<String> loginPc(HttpServletRequest request, HttpServletResponse httpResponse,
                                    @ApiParam(name = "user") @RequestBody @Valid LoginInfoVO user, BindingResult validResults) {
        if (validResults.hasFieldErrors()) {
            String error = ValidUtil.convertParamError(validResults.getFieldErrors());
            logger.warn("参数校验错误：{}" + error);
            return Response.fail(Constants.MSG_REQUEST_ERROR);
        }
        if (StringUtils.isBlank(user.getSalt()) || StringUtils.isBlank(user.getSign())) {
            return Response.fail("4000", InternationalEnums.AUTHCONTROLLER1.getCode(), "");
        }
        //验证签名
        Response response = checkSign(user);
        if (response != null) {
            return response;
        }
        //SM2还原密码
        String passWord = SM2_NEW.decryptWithSalt(user.getPassword());
        if (null == passWord) {
            return Response.fail(Constants.SYSTEM_MSG_ACCOUNT_PWD_ERROR.getName());
        }
        String accountName = SM2_NEW.decryptWithSalt(user.getAccount());
        if (null == accountName) {
            return Response.fail(Constants.SYSTEM_MSG_ACCOUNT_PWD_ERROR.getName());
        }
        Response<String> ret = login(request, httpResponse, accountName, passWord, true, user.getLanguageCode(), PC);
        if (ReturnCode.SUCCESS.getCode().equals(ret.getCode())) {
            RequestContext rc = ContextHolder.get();
            logger.info("学员pc端用户登录上下文=" + JSON.toJSONString(rc));
            boolean isAccessToSite = isAccessToSite(rc.getAccountId(), rc.getSiteId(), rc.getCompanyId(), rc.getCompanyCode(), false);
            if (!isAccessToSite) {
                return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH);
            }

            if (ret.getData().toString().indexOf("firstLogin=true") < 0) {
                addLoginRecord(rc.getAccountId(), rc.getCompanyId(), rc.getSiteId(), rc.getOrgId(), PC);
            }
        }
        return ret;
    }

    @ApiOperation(value = "管理端管理用户登录", notes = "pc端管理用户登录", extensions = {
            @Extension(name = ReturnCode.API_SUB_FLAG, properties = {
                    @ExtensionProperty(name = SecurityError.LOGIN_INFO_ERROR, value = SecurityError.LOGIN_INFO_ERROR_MSG)})})
    @RequestMapping(value = "/loginManage", produces = {
            "application/json;charset=utf-8"}, method = RequestMethod.POST)
    public Response<String> loginManage(HttpServletRequest request, HttpServletResponse httpResponse,
                                        @ApiParam(name = "user") @RequestBody @Valid LoginInfoVO user, BindingResult validResults) {
        try {
            boolean flag = accountService.validateCaptcha(user.getCaptchaKey(), user.getCaptchaVal());                                              //图形码验证
        } catch (BizException e) {
            logger.warn("验证码校验错误：{}" + e);
            return Response.fail(e.getCode(), e.getMsg());
        }
        if (validResults.hasFieldErrors()) {
            String error = ValidUtil.convertParamError(validResults.getFieldErrors());
            logger.warn("参数校验错误：{}" + error);
            return Response.fail(Constants.MSG_REQUEST_ERROR);
        }
        if (StringUtils.isBlank(user.getSalt()) || StringUtils.isBlank(user.getSign())) {
            return Response.fail("4000", InternationalEnums.AUTHCONTROLLER1.getCode(), "");
        }
        //验证签名
        Response response = checkSign(user);
        if (response != null) {
            return response;
        }
        //SM2还原密码
        String passWord = SM2_NEW.decryptWithSalt(user.getPassword());
        if (null == passWord) {
            return Response.fail("4000", InternationalEnums.AUTHCONTROLLER2.getCode(), "");
        }
        String accountName = SM2_NEW.decryptWithSalt(user.getAccount());
        if (null == accountName) {
            return Response.fail("4000", InternationalEnums.AUTHCONTROLLER2.getCode(), "");
        }
        Response<String> ret = login(request, httpResponse, accountName, passWord, false, user.getLanguageCode(), MANAGE);

        if (ReturnCode.SUCCESS.getCode().equals(ret.getCode())) {
            logger.info("管理登陆上下文=" + JSON.toJSONString(ContextHolder.get()));
            List<AccessSite> accessSites = null;
            RequestContext context = ContextHolder.get();
            try {

                Set<Long> accessSiteIds = authService.AccessSiteIds(context.getCompanyId(), context.getAccountId());
                if (CollectionUtils.isEmpty(accessSiteIds) || !accessSiteIds.contains(context.getSiteId())) {
                    return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH);
                }
                accessSites = authService.getAccessSiteWithMenu(context.getCompanyCode(), context.getAccountId(), context.getSiteId());
            } catch (AuthNoManagementException e) {
                return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH);
            } catch (AuthNotManageException e) {
                return Response.fail(Constants.MSG_NOT_MANAGE_AUTH);
            }
            Map<String, Object> rmap = (Map<String, Object>) ret.getData();
            //是否只有社群菜单判断
            try {
                accountController.judgeWhetherIsCommunityManager(context, accessSites);
            } catch (Exception e) {
                e.printStackTrace();
                logger.error("判断社群是否只有管理员异常");
            }
            rmap.put("accessSite", accessSites); // 管理访问站点列表
            rmap.put("isOnlyCommunity", context.getIsOnlyCommunity());
            return Response.ok(rmap);
        }
        return ret;
    }

    @RequestMapping(value = "/loginWeChat", produces = {
            "application/json;charset=utf-8"}, method = RequestMethod.POST)
    public Response<String> loginWechat(HttpServletRequest request, HttpServletResponse httpResponse,
                                        @ApiParam(name = "user") @RequestBody @Valid WechatLoginInfoVO user, BindingResult validResults) {
        if (validResults.hasFieldErrors()) {
            String error = ValidUtil.convertParamError(validResults.getFieldErrors());
            logger.warn("参数校验错误：{}" + error);
            return Response.fail(Constants.MSG_REQUEST_ERROR.getName());
        }
        Response<String> ret = login(request, httpResponse, user.getAccount(), user.getPassword(), false, user.getLanguageCode(), WECHAT);
        if (ReturnCode.SUCCESS.getCode().equals(ret.getCode())) {
            RequestContext rc = ContextHolder.get();
            logger.info("微信登陆上下文=" + JSON.toJSONString(rc));
            boolean isAccessToSite = isAccessToSite(rc.getAccountId(), rc.getSiteId(), rc.getCompanyId(),
                    rc.getCompanyCode(), false);
            if (!isAccessToSite) {
                return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH.getName());
            }
            String openId = user.getOpenId();
            int terminalType = 3;
            if (user.getTerminalType() != null) {
                terminalType = user.getTerminalType().byteValue();
            }
            if (terminalType == 3 && StringUtils.isBlank(openId)) {
                return Response.fail(InternationalEnums.AUTHCONTROLLER3.getCode());
            }

            // 验证用户是否是管理权限
            TrAccountUserinfoVO info = null;

            try {
                if (terminalType == 3 || terminalType == 4 || terminalType == 5) {
                    Long companyIdTemp = rc.getCompanyId();
                    com.yizhi.system.application.domain.Company companyOne = null;
                    if (companyIdTemp != null) {
                        companyOne = iCompanyService.selectById(companyIdTemp);
                    }
                    if (companyIdTemp == null || companyOne == null) {
                        return Response.fail(ReturnCode.NOT_COMPANY_EXTIS.getMsg());
                    }

                    Long siteIdTemp = rc.getSiteId();
                    com.yizhi.system.application.domain.Site siteOne = null;
                    if (siteIdTemp != null) {
                        siteOne = siteService.selectById(siteIdTemp);
                    }
                    if (siteIdTemp == null || siteOne == null) {
                        return Response.fail(ReturnCode.NOT_SITE_EXTIS.getMsg());
                    }

                    info = weiXinClient.saveTrAccountUserinfo(openId, rc.getAccountId(), siteIdTemp, companyIdTemp, terminalType);
                    logger.info("返回实体：" + info);
                    logger.info("code的值：" + info.getCode());
                    logger.info("ACCOUNT_BIND：" + ReturnCode.ACCOUNT_BIND.getCode());
                    if (info.getCode().equals(ReturnCode.ACCOUNT_BIND.getCode())) {

                        logger.info("返回 ACCOUNT_BIND：" + info.getCode());
                        return Response.fail(ReturnCode.ACCOUNT_BIND.getCode(), ReturnCode.ACCOUNT_BIND.getMsg());
                    } else if (info.getCode().equals(ReturnCode.OPENID_BIND.getCode())) {
                        logger.info("返回 OPENID_BIND：" + info.getCode());
                        return Response.fail(ReturnCode.OPENID_BIND.getCode(), ReturnCode.OPENID_BIND.getMsg());

                    }
                    String headPortrait = info.getHeadImgUrl();
                    logger.info("返回头像：" + headPortrait);
                    if (terminalType == 3 && StringUtils.isNotBlank(headPortrait)) {
                        com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
                        account.setId(rc.getAccountId());
                        account.setHeadPortrait(headPortrait);
                        boolean updaterResult = accountService.updateById(account);
                        logger.info("更新的结果：" + updaterResult);
                    }
                    if (terminalType == 4 && StringUtils.isNotEmpty(user.getImage())) {
                        com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
                        account.setId(rc.getAccountId());
                        account.setHeadPortrait(user.getImage());
                        boolean updaterResult = accountService.updateById(account);
                        logger.info("小程序用户更新的结果：" + updaterResult);
                    }

                    if (terminalType == 5 && StringUtils.isNotEmpty(user.getImage())) {
                        com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
                        account.setId(rc.getAccountId());
                        account.setHeadPortrait(user.getImage());
                        boolean updaterResult = accountService.updateById(account);
                        logger.info("更新的结果：" + updaterResult);
                    }

                }
            } catch (Exception e) {
                logger.info("###################################调用weiXinClient.saveTrAccountUserinfo返回="
                        + JSON.toJSONString(info));
            }

            addLoginRecord(rc.getAccountId(), rc.getCompanyId(), rc.getSiteId(), rc.getOrgId(), terminalType);
        }
        return ret;
    }

    @RequestMapping(value = "/loginApi", produces = {"application/json;charset=utf-8"}, method = RequestMethod.POST)
    public Response<String> loginApi(HttpServletResponse httpResponse,
                                     @ApiParam(name = "user") @RequestBody @Valid LoginInfoApiVO user, BindingResult validResults) {
        try {
            RequestContext context = ContextHolder.get();
            logger.info("请求参数=" + JSON.toJSONString(user));
            logger.info("上下文=" + JSON.toJSONString(context));
            com.yizhi.system.application.domain.Company company = iCompanyService.get(context.getCompanyId());
            if (!StringUtils.equals(user.getAuthCode(), company.getAuthCode())) {
                // 未授权访问
                return Response.fail(SecurityReturnCode.AUTH_CODE_ERROR.getSubcode(),
                        SecurityReturnCode.AUTH_CODE_ERROR.getSubmsg());
            }
            if (validResults.hasFieldErrors()) {
                String error = ValidUtil.convertParamError(validResults.getFieldErrors());
                logger.warn("参数校验错误：{}" + error);
                // throw new ParamValidationException(error);
                return Response.fail(SecurityReturnCode.PARAMENT_ERROR.getSubcode(), error);
            }

            com.yizhi.system.application.domain.Account account = accountService.find(context.getCompanyId(), user.getAccount());

            if (account == null) {
                return Response.fail(SecurityReturnCode.ACCOUNT_PASSWD_ERROR.getSubcode(),
                        SecurityReturnCode.ACCOUNT_PASSWD_ERROR.getSubmsg());
            }
            boolean isAccessToSite = isAccessToSite(account.getId(), ContextHolder.get().getSiteId(),
                    ContextHolder.get().getCompanyId(), ContextHolder.get().getCompanyCode(), false);
            if (!isAccessToSite) {
                return Response.fail(SecurityReturnCode.NOT_SITE_ACCESS_AUTH.getSubcode(),
                        SecurityReturnCode.NOT_SITE_ACCESS_AUTH.getSubmsg());
            }
            if (!ShaEncrypt.comparePassword(user.getPassword(), account.getPassword())) {
                logger.info("用户密码错误，加密密码=" + account.getPassword() + "输入密码=" + user.getPassword());
                return Response.fail(SecurityReturnCode.ACCOUNT_PASSWD_ERROR.getSubcode(),
                        SecurityReturnCode.ACCOUNT_PASSWD_ERROR.getSubmsg());
            }
            if (!account.getEnabled() || account.getLocked()) {
                return Response.fail(SecurityReturnCode.ACCOUNT_LOCK_ERROR.getSubcode(),
                        SecurityReturnCode.ACCOUNT_LOCK_ERROR.getSubmsg());
                // 前面时间大于后面时间==1
            } else if (account.getExpiredType() == 2 && account.getEndTime().compareTo(new Date()) <= 0) {
                return Response.fail(SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubcode(),
                        SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubmsg());
            } else if (account.getExpiredType() == 3 && account.getExpiredTime().compareTo(new Date()) <= 0) {
                return Response.fail(SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubcode(),
                        SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubmsg());
            }
            Map<String, Object> info = new HashMap<String, Object>();

            info.put(GlobalConstant.ACCOUNT_ID, account.getId().toString());
            info.put(GlobalConstant.COMPANY_CODE, context.getCompanyCode());
            info.put(GlobalConstant.COMPANY_ID, context.getCompanyId().toString());
            info.put(GlobalConstant.COMPANY_NAME, context.getCompanyName());
            // 添加站点id
            info.put(GlobalConstant.SITE_ID, context.getSiteId().toString());

            // 生成令牌信息
            String token = tokenHelper.createToken(account.getName(), info);
            httpResponse.addHeader(GlobalConstant.TOKEN_HEADER, token);

            Map<String, Object> userInfo = new HashMap<String, Object>();// 用户信息
            userInfo.put("id", account.getId());// 账号id
            userInfo.put("name", account.getName());// 账号登录名
            userInfo.put("headPortrait", account.getHeadPortrait());// 头像
            userInfo.put("telephone", account.getTelephone()); // 座机
            userInfo.put("mobile", account.getMobile());// 手机号
            userInfo.put("email", account.getEmail());// 邮箱地址
            userInfo.put("fullName", account.getFullName());// 用户姓名
            userInfo.put("companyName", context.getCompanyName());
            // 获取站点信息
            com.yizhi.system.application.domain.Organization organization = organizationService.selectById(account.getOrgId());
            userInfo.put("orgName", organization.getName());
            userInfo.put("wechatId", account.getWechat());// 微信号
            Map<String, Object> retMap = new HashMap<>();
            // 返回令牌信息
            retMap.put(GlobalConstant.TOKEN_HEADER, token);
            // retMap.put(GlobalConstant.TOKEN_HEADER, "");
            retMap.put("userInfo", userInfo);
            retMap.put("siteId", context.getSiteId().toString());
            ContextHolder.set(context);
            try {
                retMap.putAll(isEnableSign(context.getSiteId(), account.getId()));
            } catch (Exception e) {
                logger.error("服务异常", e);
                retMap.put("isEnableSign", 0);
            }
            //登录成功，设置用户选择的语言
            languageUtil.setStudentSelectLanguage(context, user.getLanguageCode());
            addLoginRecord(account.getId(), context.getCompanyId(), context.getSiteId(), account.getOrgId(), 4);
            return Response.ok(retMap);
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }

    }

    /**
     * 验证用户authorization是否合法
     *
     * @param validResults
     * @return
     */
    @RequestMapping(value = "/authApi", produces = {"application/json;charset=utf-8"}, method = RequestMethod.POST)
    public Response<String> loginApi(@RequestBody @Valid AuthorizationVO authorizationVO, BindingResult validResults) {
        logger.info("请求参数=" + JSON.toJSONString(authorizationVO));
        logger.info("上下文=" + JSON.toJSONString(ContextHolder.get()));
        com.yizhi.system.application.domain.Company company = iCompanyService.get(ContextHolder.get().getCompanyId());
        if (!StringUtils.equals(authorizationVO.getAuthCode(), company.getAuthCode())) {
            // 未授权访问
            return Response.fail(SecurityReturnCode.AUTH_CODE_ERROR.getSubcode(),
                    SecurityReturnCode.AUTH_CODE_ERROR.getSubmsg());
        }
        if (validResults.hasFieldErrors()) {
            String error = ValidUtil.convertParamError(validResults.getFieldErrors());
            logger.warn("参数校验错误：{}" + error);
            // throw new ParamValidationException(error);
            return Response.fail(SecurityReturnCode.PARAMENT_ERROR.getSubcode(), error);
        }

        // 获取令牌对象
        String token = authorizationVO.getAuthorization();
        logger.info("令牌信息=token{}", token);
        if (StringUtils.isEmpty(token)) {
            logger.info("令牌信息为空，请重新登陆获取令牌信息");
            return Response.fail(ReturnCode.NO_TOKEN.getCode(), ReturnCode.NO_TOKEN.getMsg());
        }
        Claims claims = tokenHelper.parseToken(token);
        if (claims == null) {
            logger.info("解析令牌为空，令牌失效或者过期，请重新登陆");
            return Response.fail(ReturnCode.TOKEN_INVALID.getCode(), ReturnCode.TOKEN_INVALID.getMsg());
        }
        // 获取用户ID
        Long accountId = Long.valueOf(claims.get(GlobalConstant.ACCOUNT_ID, String.class));
        com.yizhi.system.application.domain.Account account = accountService.get(accountId);
        if (account == null) {
            return Response.fail(SecurityReturnCode.ACCOUNT_PASSWD_ERROR.getSubcode(),
                    SecurityReturnCode.ACCOUNT_PASSWD_ERROR.getSubmsg());
        }
        if (!account.getEnabled() || account.getLocked()) {
            return Response.fail(SecurityReturnCode.ACCOUNT_LOCK_ERROR.getSubcode(),
                    SecurityReturnCode.ACCOUNT_LOCK_ERROR.getSubmsg());
            // 前面时间大于后面时间==1
        } else if (account.getExpiredType() == 2 && account.getEndTime().compareTo(new Date()) <= 0) {
            return Response.fail(SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubcode(),
                    SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubmsg());
        } else if (account.getExpiredType() == 3 && account.getExpiredTime().compareTo(new Date()) <= 0) {
            return Response.fail(SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubcode(),
                    SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubmsg());
        }

        Map<String, Object> userInfo = new HashMap<String, Object>();// 用户信息
        RequestContext context = ContextHolder.get();
        userInfo.put("id", account.getId());// 账号id
        userInfo.put("name", account.getName());// 账号登录名
        userInfo.put("headPortrait", account.getHeadPortrait());// 头像
        userInfo.put("telephone", account.getTelephone()); // 座机
        userInfo.put("mobile", account.getMobile());// 手机号
        userInfo.put("email", account.getEmail());// 邮箱地址
        userInfo.put("fullName", account.getFullName());// 用户姓名
        userInfo.put("companyName", context.getCompanyName());
        // 获取站点信息
        com.yizhi.system.application.domain.Organization organization = organizationService.selectById(account.getOrgId());
        userInfo.put("orgName", organization.getName());
        userInfo.put("wechatId", account.getWechat());// 微信号
        Map<String, Object> retMap = new HashMap<>();
        retMap.put("userInfo", userInfo);
        retMap.put("siteId", context.getSiteId().toString());
        try {
            retMap.putAll(isEnableSign(context.getSiteId(), accountId));
        } catch (Exception e) {
            logger.error("服务异常", e);
            retMap.put("isEnableSign", 0);
        }
        addLoginRecord(account.getId(), context.getCompanyId(), context.getSiteId(), account.getOrgId(), 5);
        return Response.ok(retMap);

    }

    @RequestMapping(value = "/getWechat", produces = {"application/json;charset=utf-8"}, method = RequestMethod.POST)
    public Response<String> loginApi(@RequestBody @Valid FindOpenIdVO authorizationVO, BindingResult validResults) {
        logger.info("请求参数=" + JSON.toJSONString(authorizationVO));
        logger.info("上下文=" + JSON.toJSONString(ContextHolder.get()));
        com.yizhi.system.application.domain.Company company = iCompanyService.get(ContextHolder.get().getCompanyId());
        if (!StringUtils.equals(authorizationVO.getAuthCode(), company.getAuthCode())) {
            // 未授权访问
            return Response.fail(SecurityReturnCode.AUTH_CODE_ERROR.getSubcode(),
                    SecurityReturnCode.AUTH_CODE_ERROR.getSubmsg());
        }
        if (validResults.hasFieldErrors()) {
            String error = ValidUtil.convertParamError(validResults.getFieldErrors());
            logger.warn("参数校验错误：{}" + error);
            // throw new ParamValidationException(error);
            return Response.fail(SecurityReturnCode.PARAMENT_ERROR.getSubcode(), error);
        }

        // 获取令牌对象
        String token = authorizationVO.getAuthorization();
        logger.info("令牌信息=token{}", token);
        if (StringUtils.isEmpty(token)) {
            logger.info("令牌信息为空，请重新登陆获取令牌信息");
            return Response.fail(ReturnCode.NO_TOKEN.getCode(), ReturnCode.NO_TOKEN.getMsg());
        }
        Claims claims = tokenHelper.parseToken(token);
        if (claims == null) {
            logger.info("解析令牌为空，令牌失效或者过期，请重新登陆");
            return Response.fail(ReturnCode.TOKEN_INVALID.getCode(), ReturnCode.TOKEN_INVALID.getMsg());
        }
        // 获取用户ID
        Long accountId = Long.valueOf(claims.get(GlobalConstant.ACCOUNT_ID, String.class));
        com.yizhi.system.application.domain.Account account = accountService.get(accountId);
        if (account == null) {
            return Response.fail(SecurityReturnCode.ACCOUNT_PASSWD_ERROR.getSubcode(),
                    SecurityReturnCode.ACCOUNT_PASSWD_ERROR.getSubmsg());
        }
        if (!account.getEnabled() || account.getLocked()) {
            return Response.fail(SecurityReturnCode.ACCOUNT_LOCK_ERROR.getSubcode(),
                    SecurityReturnCode.ACCOUNT_LOCK_ERROR.getSubmsg());
            // 前面时间大于后面时间==1
        } else if (account.getExpiredType() == 2 && account.getEndTime().compareTo(new Date()) <= 0) {
            return Response.fail(SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubcode(),
                    SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubmsg());
        } else if (account.getExpiredType() == 3 && account.getExpiredTime().compareTo(new Date()) <= 0) {
            return Response.fail(SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubcode(),
                    SecurityReturnCode.ACCOUNT_INVALID_ERROR.getSubmsg());
        }

        weiXinClient.getWechatIdbyAccountId(authorizationVO.getAccountId());

        return Response.ok(weiXinClient.getWechatIdbyAccountId(authorizationVO.getAccountId()));

    }

    /**
     * 是否有站点访问权限
     *
     * @param aid         账号id
     * @param sid         站点id
     * @param companyCode
     * @param isManage    true:为后台管理登陆
     * @return
     */
    private boolean isAccessToSite(long aid, long sid, long companyId, String companyCode, boolean isManage) {
        logger.info("登陆是否站点访问权限接口调用，账号id={},站点id={},是否是管理登陆", aid, sid, isManage);
        boolean siteAccount = false;
        Set<Long> siteIds = new HashSet<>();
        if (isManage) {
            siteIds = authService.AccessSiteIds(companyId, aid);
        } else {
            siteIds = authService.AccessSiteIdsFront(companyId, companyCode, aid);
        }

        if (!CollectionUtils.isEmpty(siteIds)) {
            return siteIds.contains(sid);
        }

        return false;
    }

    /**
     * 添加登陆记录
     */
    private void addLoginRecord(long accountId, long companyId, long siteId, long orgId, int type) {
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                com.yizhi.system.application.domain.LoginLog loginLog = new com.yizhi.system.application.domain.LoginLog();
                loginLog.setAccountId(accountId);
                loginLog.setCompanyId(companyId);
                loginLog.setSiteId(siteId);
                loginLog.setOrgId(orgId);
                loginLog.setLoginDate(new Date());
                loginLog.setLoginType(type);
                loginLogService.insert(loginLog);
            }
        });
    }

    @ApiOperation(value = "手机APP端免用户登录（只对国投信达企业）", notes = "手机APP端免用户登录（只对国投信达企业）", extensions = {
            @Extension(name = ReturnCode.API_SUB_FLAG, properties = {
                    @ExtensionProperty(name = SecurityError.LOGIN_INFO_ERROR, value = SecurityError.LOGIN_INFO_ERROR_MSG)})})
    @RequestMapping(value = "/loginAppNoUser", produces = {
            "application/json;charset=utf-8"}, method = RequestMethod.POST)
    public Response<String> loginAppNoUser(HttpServletResponse httpResponse) {
        logger.info("手机APP端免用户登录开始（只对国投信达企业）");

        RequestContext context = ContextHolder.get();
        com.yizhi.system.application.domain.Account account = accountService.find(context.getCompanyId(), "admin");
        // 国投信达
        if (!context.getCompanyCode().equals("guotouxinda")) {
            logger.info("code={},id={} 非法访问该站点", context.getCompanyCode(), context.getCompanyId());
            return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH.getCode().toString(), Constants.MSG_NOT_SITE_ACCESS_AUTH.getName());
        }
        if (account == null) {
            logger.info("手机APP端免用户登录（只对国投信达企业）-没有查询到管理员用户，临时新增加个sysadmin用户");
            account = new com.yizhi.system.application.domain.Account();
            account.setId(99999L);
            account.setName("sysadmin");
            account.setCompanyId(context.getCompanyId());
            account.setCompanyName(context.getCompanyName());
        }
        Map<String, Object> info = new HashMap<String, Object>();

        info.put(GlobalConstant.ACCOUNT_ID, account.getId().toString());
        info.put(GlobalConstant.COMPANY_CODE, context.getCompanyCode());
        info.put(GlobalConstant.COMPANY_ID, context.getCompanyId().toString());
        info.put(GlobalConstant.COMPANY_NAME, context.getCompanyName());
        // 添加站点id
        info.put(GlobalConstant.SITE_ID, context.getSiteId().toString());
        context.setAccountId(account.getId());
        context.setOrgId(context.getOrgId());
        account.setPassword("");

        Map<String, Object> retMap = new HashMap<>();
        String token = tokenHelper.createToken(account.getName(), info);
        httpResponse.addHeader(GlobalConstant.TOKEN_HEADER, token);
        retMap.put(GlobalConstant.TOKEN_HEADER, token);
        ContextHolder.set(context);
        try {
            retMap.putAll(isEnableSign(context.getSiteId(), context.getAccountId()));
        } catch (Exception e) {
            logger.error("服务异常", e);
            retMap.put("isEnableSign", 0);
        }
        if (!StringUtils.isBlank(token)) {
            // logger.info("手机APP端免用户登录=" + JSON.toJSONString(ContextHolder.get()));
            addLoginRecord(ContextHolder.get().getAccountId(), ContextHolder.get().getCompanyId(),
                    ContextHolder.get().getSiteId(), ContextHolder.get().getOrgId(), 2);
        } else {
            return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH.getCode().toString(), Constants.MSG_NOT_SITE_ACCESS_AUTH.getName());
        }

        logger.info("手机APP端免用户登录结束（只对国投信达企业）");

        return Response.ok(retMap);
    }

    @RequestMapping(value = "/loginBindWechat", produces = {
            "application/json;charset=utf-8"}, method = RequestMethod.POST)
    public Response<String> noLoginWechat(HttpServletResponse httpResponse,
                                          @RequestParam(name = "openId", required = true) String openId) {

        RequestContext context = ContextHolder.get();
        Map<String, Object> retMap = new HashMap<>();
        TrAccountUserinfoVo wAccountUserinfo = new TrAccountUserinfoVo();
        wAccountUserinfo.setCompanyId(context.getCompanyId());
        wAccountUserinfo.setWechatuserid(openId);
//		wAccountUserinfo.setSiteId(context.getSiteId());
//		wAccountUserinfo.setCreateTime(new Date());
//		wAccountUserinfo.setType(3);
        logger.info("传参" + "wAccountUserinfo: " + wAccountUserinfo.toString());
        TrAccountUserinfoVo trAccountUserinfo = weiXinClient.getAccountUserInfo(wAccountUserinfo);
        if (trAccountUserinfo == null) {
            return Response.fail(InternationalEnums.AUTHCONTROLLER4.getCode());
        }

        com.yizhi.system.application.domain.Account user = accountService.selectById(trAccountUserinfo.getAccountId());
        if (user == null) {
            return Response.fail(InternationalEnums.AUTHCONTROLLER5.getCode());
        }

        Map<String, Object> info = new HashMap<String, Object>();
        info.put(GlobalConstant.ACCOUNT_ID, String.valueOf(user.getId()));
        info.put(GlobalConstant.COMPANY_CODE, context.getCompanyCode());
        info.put(GlobalConstant.COMPANY_ID, context.getCompanyId().toString());
        info.put(GlobalConstant.COMPANY_NAME, context.getCompanyName());
        // 添加站点id
        info.put(GlobalConstant.SITE_ID, context.getSiteId().toString());
        context.setAccountId(trAccountUserinfo.getAccountId());
        context.setOrgId(user.getOrgId());
        String token = tokenHelper.createToken(user.getName(), info);
        httpResponse.addHeader(GlobalConstant.TOKEN_HEADER, token);
        user.setPassword("");
        // 返回token信息
        retMap.put("userInfo", user);
        retMap.put(GlobalConstant.TOKEN_HEADER, token);
        retMap.put("siteId", context.getSiteId().toString());
        try {
            retMap.putAll(isEnableSign(context.getSiteId(), user.getId()));
        } catch (Exception e) {
            logger.error("服务异常", e);
            retMap.put("isEnableSign", 0);
        }
        if (!StringUtils.isBlank(token)) {
            addLoginRecord(user.getId(), context.getCompanyId(), context.getSiteId(), user.getOrgId(), 3);
        } else {
            return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH.getCode().toString(), Constants.MSG_NOT_SITE_ACCESS_AUTH.getName());
        }
        return Response.ok(retMap);
    }

    /**
     * 签到打卡显示查询
     *
     * @param siteId
     * @param accountId
     * @return
     */
    @HystrixCommand(fallbackMethod = "getIsSignHystrix")
    public Map<String, Object> isEnableSign(Long siteId, Long accountId) {
        Map<String, Object> map = new HashMap<String, Object>();
        List<Integer> terminalType = new ArrayList<>();
        terminalType.add(2);
        terminalType.add(3);
        CalendarVO calendar = calendarClient.getCalendar();
        List<FunctionDisplayConfigVo> list = functionClient.getBySiteId(siteId);
        List<MyItemConfigVO> voList = myItemConfigApiClients.queryByAuthoity(terminalType);
        map.put("isEnableSign", 0);
        map.put("isPCEnableSign", 0);
        map.put("isAPPEnableSign", 0);
        if (calendar != null) {
            map.put("isEnableSign", calendar.getState());
            if (calendar.getState() == 1) {
                SimpleDateFormat format = new SimpleDateFormat("yyyMMdd");
                Date date = new Date();
                if (redisCache.exists(format.format(date) + accountId + siteId)) {
                    logger.info("key存在：" + format.format(date) + accountId + siteId);
                    map.put("isFirstLogin", 0);
                } else {
                    redisCache.hset(format.format(date) + accountId + siteId, format.format(date) + accountId + siteId, "0", 86500l);
                    logger.info("key不存在，设key：" + format.format(date) + accountId + siteId);
                    map.put("isFirstLogin", 1);
                }
            }
        } else {
            map.put("isFirstLogin", 0);
        }
        //如果我的配置表没有数据，取默认表里的数据
        if (CollectionUtils.isEmpty(voList)) {
            voList = myItemConfigDefaultApiClients.queryByAuthoity(terminalType);
        }
        if (!CollectionUtils.isEmpty(list)) {
            logger.info("签到打卡PC端显示配置" + list.toString());
            for (FunctionDisplayConfigVo config : list) {
                if (config.getFunctionType().equals(FunctionTypeCode.SIGN.getCode()) && config.getShowDisplay()) {
                    map.put("isPCEnableSign", 1);
                }
            }
        }
        if (!CollectionUtils.isEmpty(voList)) {
            logger.info("签到打卡移动端显示配置" + voList.toString());
            for (MyItemConfigVO vo : voList) {
                if (vo.getItemType() == 15 && vo.getShowable() == 1) {
                    map.put("isAPPEnableSign", 1);
                }
            }
        }
        return map;
    }

    //calendar或site服务异常时调用该方法
    public Map<String, Object> getIsSignHystrix() {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("isEnableSign", 0);
        return map;
    }

    @RequestMapping(value = "/checkToken", produces = {
            "application/json;charset=utf-8"}, method = RequestMethod.POST)
    public Response<String> checkToken(HttpServletResponse httpResponse, @RequestBody TokenVo vo) {

        // 获取令牌对象
        String token = vo.getAuthorization();
        String type = vo.getTerminalType();
        if (StringUtils.isNotBlank(token)) {
            Claims claims = tokenHelper.parseToken(token);
            if (claims != null) {
                // 获取用户ID
                Long accountId = Long.valueOf(claims.get(GlobalConstant.ACCOUNT_ID, String.class));
                Long siteId = Long.valueOf(claims.get(GlobalConstant.SITE_ID, String.class));
                Long companyId = Long.valueOf(claims.get(GlobalConstant.COMPANY_ID, String.class));
                String companyCode = String.valueOf(claims.get(GlobalConstant.COMPANY_CODE, String.class));
                String siteCode = String.valueOf(claims.get(GlobalConstant.SITE_CODE, String.class));
                // 获取用户的账号信息
                com.yizhi.system.application.domain.Account account = accountService.selectById(accountId);
                AccountVO accountVO = new AccountVO();
                if (account != null) {
                    BeanUtils.copyProperties(account, accountVO);
                    com.yizhi.system.application.domain.Organization organization = iOrganizationService.selectById(accountVO.getOrgId());
                    if (Objects.nonNull(organization)) {
                        accountVO.setOrgName(organization.getName());
                    }
                }
                List<AccessSite> accessSites = null;
                try {
                    Set<Long> accessSiteIds = authService.AccessSiteIds(companyId, accountId);
                    if (CollectionUtils.isEmpty(accessSiteIds) || !accessSiteIds.contains(siteId)) {
                        return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH.getCode().toString(), Constants.MSG_NOT_SITE_ACCESS_AUTH.getName());
                    }
                    accessSites = authService.getAccessSiteWithMenu(companyCode, accountId,
                            siteId);
                } catch (AuthNoManagementException e) {
                    return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH.getCode().toString(), Constants.MSG_NOT_SITE_ACCESS_AUTH.getName());
                } catch (AuthNotManageException e) {
                    return Response.fail(Constants.MSG_NOT_MANAGE_AUTH.getCode().toString(), Constants.MSG_NOT_MANAGE_AUTH.getName());
                }
                // 用户信息
                Map<String, Object> retMap = new HashMap<String, Object>();
                retMap.put("userInfo", accountVO);
                retMap.put(GlobalConstant.TOKEN_HEADER, token);
                retMap.put("accessSite", accessSites); // 管理访问站点列表
                if (type != null && !type.equals(0)) {
                    addLoginRecord(accountId, companyId, siteId, accountVO.getOrgId(), Integer.valueOf(type));
                }
                // 根据用户ID集合查询角色集合
                List<AuthzAccountRole> authzAccountRoleList = authzAccountRoleService.getRoleIdsByAccountIds(Collections.singletonList(accountId));
                // 组装角色ID集合
                List<Long> roleIdList = authzAccountRoleList.stream().map(AuthzAccountRole::getRoleId).collect(Collectors.toList());
                // 根据角色ID集合查询角色名称
                List<AuthzRole> authzRoles =roleService.selectBatchIds(roleIdList);
                retMap.put("authRole", authzRoles);
                return Response.ok(retMap);
            } else {
                return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH.getCode().toString(), Constants.MSG_NOT_SITE_ACCESS_AUTH.getName());
            }
        } else {
            return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH.getCode().toString(), Constants.MSG_NOT_SITE_ACCESS_AUTH.getName());
        }
    }

    /**
     * url编码字符
     *
     * @param val
     * @return
     */
    private static String urlEncoder(String val) {
        String retStr = "";
        try {
            retStr = URLEncoder.encode(StringUtils.trimToEmpty(val), "UTF-8");
        } catch (UnsupportedEncodingException e) {
            logger.info("中文字符串通过url编码失败，异常信息=" + JSON.toJSONString(e));
        }
        return retStr;
    }

    /**
     * 记录学员最后一次的登录站点code 专区需要
     *
     * @param accountId
     * @param context
     */
    private void setStudentLastLoginRecordCache(Long accountId, RequestContext context) {
        if (accountId == null) {
            logger.info("记录登录记录时用户id为空");
            return;
        }
        String key = CacheNamespace.SITE_STUDENT_LAST_LOGIN_RECORDS;
        String value = context.getCompanyCode() + "/" + context.getSiteCode();
        redisCache.hset(key, accountId.toString(), value);
    }

}
