package com.yizhi.system.application.controller.api;


import com.alibaba.fastjson.JSON;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.SmsSendBizType;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.system.application.feign.SmsSendRecordClient;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.ISmsSendRecordService;
import com.yizhi.system.application.service.impl.SmsSendRecordServiceImpl;
import com.yizhi.system.application.util.SmsUtil;
import com.yizhi.system.application.vo.SmsSendVo;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * <p>
 * 短信发送记录表 前端控制器
 * </p>
 *
 * @author 谢海军123
 * @since 2018-12-06
 */
@Api(tags = "短信发送接口")
@RestController
@RequestMapping("/api/smsSendRecord")
public class SmsSendRecordController {

    @Autowired
    private IAccountService accountService;

    @Autowired
    private ISmsSendRecordService smsSendRecordService;

    @Autowired
    private RedisCache redisCache;

    private static final Logger logger = LoggerFactory.getLogger(SmsSendRecordController.class);

    @ApiOperation(value = "忘记密码", notes = "忘记密码发送短信")
    @GetMapping(value = "/public/forget/pwd/send/sms")
    public Response<String> forgetPwdUpdate(@ApiParam(required = true, value = "手机号")
                                            @RequestParam("mobile") long mobile) {
        String smsSendRequest = getSmsRequsetNo();
        try {
            com.yizhi.system.application.domain.Account account = accountService.mobileBindCheck(mobile);
            int romdom = getRandomNum();
            String templateParam = "{\"code\":\""+romdom+"\"}";

            smsSendRecordService.sendSms(templateParam,null,account.getId(),null,
                    SmsSendBizType.FORGET_PWD,smsSendRequest,mobile);
        } catch (BizException e) {
            return Response.fail(e.getCode(),e.getMsg());
        }

        Map<String,String> retData = new HashMap<>();
        retData.put("smsSendRequestNo",smsSendRequest);
        return Response.ok(retData);
    }

    @ApiOperation(value = "首次登陆", notes = "首次登陆修改密码发送短信验证码")
    @GetMapping(value = "/public/first/login/send/sms")
    public Response<String> firstLoginPwdUpdate(@ApiParam(required = true, value = "登陆账号id")
                                                @RequestParam("accountId") Long accountId,
                                                @ApiParam(required = true, value = "手机号")
                                                @RequestParam("mobile") long mobile ) {
        RequestContext rc = ContextHolder.get();
        String smsSendRequest = getSmsRequsetNo();
        logger.info("请求参数 accountId={}，mobile={}", accountId,mobile);
        com.yizhi.system.application.domain.Account account = accountService.selectById(accountId);
        if(account == null){
            //  账号不存在
            return Response.fail(Constants.SYSTEM_MSG_ACCOUNT_NOT_EXIST);
        }
        logger.info("账号信息={}", JSON.toJSONString(account));

        String mobileDb = account.getMobile();
        if(!StringUtils.isEmpty(mobileDb) && !mobileDb.trim().equals(String.valueOf(mobile))){
            // 与账号绑定的手机号不符
            return Response.fail(Constants.SYSTEM_MSG_MOBILE_NUMBER_UNBOUND);
        }
        // 验证手机号是否被绑定过
        com.yizhi.system.application.domain.Account accountPhone = new com.yizhi.system.application.domain.Account();
        accountPhone.setMobile(String.valueOf(mobile));
        accountPhone.setCompanyId(rc.getCompanyId());
        List<com.yizhi.system.application.domain.Account> exitsAccount = accountService.selectList(QueryUtil.condition(accountPhone));
        if(StringUtils.isEmpty(mobileDb) && CollectionUtils.isNotEmpty(exitsAccount)){
            long noExits = exitsAccount.stream().filter(userId-> !userId.equals(accountId)).count();
            if(noExits>0){
                return Response.fail(Constants.SYSTEM_MSG_MOBILE_MULTIPLE_ACCOUNTS_BOUND);
            }
        }

        // 发送短信
        int romdom = getRandomNum();
        String templateParam = "{\"code\":\""+romdom+"\"}";
        logger.info("短信验证码={}", templateParam);
        smsSendRecordService.sendSms(templateParam,null,account.getId(),null,
                SmsSendBizType.FIRST_LOGIN,smsSendRequest,mobile);

        Map<String,String> retData = new HashMap<>();
        retData.put("smsSendRequestNo",smsSendRequest);
        return Response.ok(retData);
    }

    /**
     * 简单短信发送接口，可以指定发送内容和短信模板id已经签名 ，如果自己指定发送内容，发送成功不返回验证码
     * @return
     */
    @ApiOperation(value = "简单发送短信，返回发送的验证码(key 为code，key为其他表示异常；如果自己指定发送内容，发送成功不返回验证码", notes = "通用的短信发送接口，参数可选，不传使用默认的")
    @PostMapping(value = "/simple/sms/send")
    public Map<String,Object> simpleSmsSend(@RequestBody SmsSendVo smsSendVo){

        Map<String,Object> data = new HashMap<>();

        String tel = smsSendVo.getTel();
        // 验证手机号
        if(tel==null || tel.length() != 11 || !isMobile(tel)){
            data.put(Constants.SYSTEM_MSG_MOBILE_NUMBER_ILLEGAL.getCode().toString(), Constants.SYSTEM_MSG_MOBILE_NUMBER_ILLEGAL.getName());
            return data;
        }

        // 短信签名
        String signName = smsSendVo.getSignName();
        if(org.apache.commons.lang3.StringUtils.isBlank(signName)){
            signName = SmsSendRecordServiceImpl.DEFALAT_SIGN_NAME;
        }

        // 短信模板
        String templateCode = smsSendVo.getTemplateCode();
        if(org.apache.commons.lang3.StringUtils.isBlank(templateCode)){
            templateCode = SmsSendRecordServiceImpl.DEFALAT_TEMPLATE_CODE;
        }

        // 短信发送内容
        String templateParam = smsSendVo.getTemplateParam();
        int romdom = getRandomNum();
        if(org.apache.commons.lang3.StringUtils.isBlank(templateParam)){
            templateParam = "{\"code\":\""+romdom+"\"}";
        }

        try {
            SendSmsResponse ret = SmsUtil.simpleSend(signName,templateCode,templateParam,
                    null,null, Long.valueOf(tel) );
            if(ret.getCode() != null && ret.getCode().equals("OK")) {
                data.put(SmsSendRecordClient.SUCCESS_CODE, romdom);
                return data; // 发送成功
            }else {
                if(ret.getCode() != null && ret.getCode().equals("isv.MOBILE_NUMBER_ILLEGAL")){
                    // 非法手机号
                    data.put(Constants.SYSTEM_MSG_MOBILE_NUMBER_ILLEGAL.getCode().toString()
                            ,Constants.SYSTEM_MSG_MOBILE_NUMBER_ILLEGAL.getName());
                    return data;
                }else if(ret.getCode() != null && ret.getCode().equals("isv.isv.BUSINESS_LIMIT_CONTROL")){// 触发分钟级流控Permits:1
                    // 手机号发送太频繁限制
                    data.put(Constants.SYSTEM_MSG_SMS_SEND_MAX_LIMIT.getCode().toString()
                            ,Constants.SYSTEM_MSG_SMS_SEND_MAX_LIMIT.getName());
                    return data;
                }
                // 短信发送异常，请重试或者联系管理员
                data.put(Constants.SYSTEM_MSG_SMS_SEND_ERROR.getCode().toString()
                        ,Constants.SYSTEM_MSG_SMS_SEND_ERROR.getName());
                return data;
            }
        } catch (ClientException e) {
            //log.info("发送短信异常{}",e);
            // 短信发送异常，请重试或者联系管理员
            data.put(Constants.SYSTEM_MSG_SMS_SEND_ERROR.getCode().toString()
                    ,Constants.SYSTEM_MSG_SMS_SEND_ERROR.getName());
            return data;
        }

    }

    /**
     * 手机号验证
     * @param  str
     * @return 验证通过返回true
     */
    public static boolean isMobile(final String str) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,6,7,8,9][0-9]{9}$"); // 验证手机号
        m = p.matcher(str);
        b = m.matches();
        return b;
    }


      /**
       * 产生随机数
       * @return
       */
    public int getRandomNum() {
        return new Random().ints(1, 100000, 999999).findFirst().getAsInt();
    }

    public String getSmsRequsetNo(){
        return Calendar.getInstance().getTimeInMillis()+""+getRandomNum();
    }


    @ApiOperation(value = "手机号登陆", notes = "手机号登陆修改密码发送短信验证码")
    @GetMapping(value = "/public/mobile/login/send/sms")
    public Response<String> mobileLoginPwdUpdate(@ApiParam(required = true, value = "请求ID")
                                                @RequestParam("captchaKey") String captchaKey,
                                                 @ApiParam(required = true, value = "图形验证码")
                                                 @RequestParam("imgVerifyCode") String imgVerifyCode,
                                                @ApiParam(required = true, value = "手机号")
                                                @RequestParam("mobile") long mobile ) {
        String smsSendRequest = getSmsRequsetNo();
        Object imgVerifyCodeRd = redisCache.hget(KaptchaController.VRIFY_CODE,
                org.apache.commons.lang3.StringUtils.trimToEmpty(captchaKey));
        if(imgVerifyCodeRd==null){
            //图形验证码已过期
            return Response.fail(Constants.SYSTEM_MSG_IMG_VERIFY_CODE_EXPIRED);
        }else if(!imgVerifyCode.equalsIgnoreCase(imgVerifyCodeRd.toString())){
            // 图形验证码不正确
            return Response.fail(Constants.SYSTEM_MSG_IMG_VERIFY_CODE_NOT_CORRECT);
        }
        try {
            com.yizhi.system.application.domain.Account account = accountService.mobileBindCheck(mobile);
            // 发送短信
            int romdom = getRandomNum();
            String templateParam = "{\"code\":\""+romdom+"\"}";
            smsSendRecordService.sendSms(templateParam,null,account.getId(),null,
                    SmsSendBizType.MOBILE_LOGIN,smsSendRequest,mobile);
        } catch (BizException e) {
            return Response.fail(e.getCode(),e.getMsg());
        }

        Map<String,String> retData = new HashMap<>();
        retData.put("smsSendRequestNo",smsSendRequest);
        return Response.ok(retData);
    }
    /**
          * 先对手机号进行验证，通过则发送短信验证码
          * @param mobile
          * @return
          */
    @ApiOperation(value = "手机号修改", notes = "用户修改手机号发送短信验证码")
    @GetMapping(value = "/public/mobile/updatePhone/send/sms")
    public Response<String> updatePhoneNum(@ApiParam(required = true, value = "手机号") @RequestParam("mobile") String mobile) {
        RequestContext requestContext = ContextHolder.get();

        try {
             accountService.VerifyPhoneNum(mobile);     //验证手机号
            // 发送短信
            int romdom = new Random().ints(1, 100000, 999999).findFirst().getAsInt();
            String templateParam = "{\"code\":\"" + romdom + "\"}";
            Long accountId = requestContext.getAccountId();
            smsSendRecordService.sendSms(templateParam, null, accountId, null, SmsSendBizType.UPDATE_MOBILE, Long.valueOf(mobile));
        } catch (BizException e) {
            if (Constants.SYSTEM_MSG_MOBILE_NUMBER_ILLEGAL.getCode().toString().equals(e.getCode())){
                return Response.fail(e.getCode(), e.getMsg());   //手机号不正确
            }
            if (Constants.SYSTEM_MSG_MOBILE_MULTIPLE_ACCOUNTS_BOUND.getCode().toString().equals(e.getCode())){
                return Response.fail(e.getCode(), e.getMsg());  //手机号已被绑定
            }
            if (Constants.SYSTEM_MSG_SMS_SEND_MAX_LIMIT.getCode().toString().equals(e.getCode())){
                return Response.fail(e.getCode(), e.getMsg());  //短信发送次数超过最大次数
            }
            if (Constants.SYSTEM_MSG_SMS_SEND_ERROR.getCode().toString().equals(e.getCode())){
                return Response.fail(e.getCode(), e.getMsg()); //短信发送错误
            }

        }
        return Response.ok();
    }
}

