package com.yizhi.system.application.controller.manage;

import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.orm.page.PageUtil;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.course.application.vo.RangeImportParamVo;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.IAuthzGroupMemberService;
import com.yizhi.system.application.service.IAuthzUserGroupService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.service.using.AccountRangeExportService;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.OrgVO;
import com.yizhi.system.application.vo.UserGroupPageVO;
import com.yizhi.system.application.vo.UserGroupVO;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.page.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * <p>
 * 用户组管理前端控制器
 * </p>
 *
 * @author yinyuyan
 * @date 2018.4.16
 */
@Api(tags = "用户组管理接口")
@RestController
@RequestMapping(value = "/manage/group")
public class GroupController {

    @Autowired
    IAuthzUserGroupService groupService;
    @Autowired
    IAccountService accountService;
    @Autowired
    IOrganizationService orgService;
    @Autowired
    private IAuthzGroupMemberService groupMemberService;
    @Autowired
    DomainConverter converter;
    @Autowired
    private AccountRangeExportService accountRangeExportService;
    @Autowired
    private GroupMemberImport groupMemberImport;


    private static final Logger logger = LoggerFactory.getLogger(GroupController.class);

    /**
     * 增加用户组
     *
     * @param groupVO
     * @return
     */
    @ApiOperation(value = "插入用户组信息", notes = "插入用户组信息")
    @PostMapping(value = "/insert")
    public Response<String> insert(@RequestBody UserGroupVO groupVO) {
        try {
            if (null == groupVO) {
                throw new BizException(ReturnCode.PARAM_INVALID.getCode(), ReturnCode.PARAM_INVALID.getMsg());
            }
            com.yizhi.system.application.domain.AuthzUserGroup group = (com.yizhi.system.application.domain.AuthzUserGroup) converter.toDO(groupVO, com.yizhi.system.application.domain.AuthzUserGroup.class);
            group.setCompanyId(ContextHolder.get().getCompanyId());
            group.setSiteId(ContextHolder.get().getSiteId());
            group.setAccountIds(groupVO.getAccountIds());
            groupService.save(group);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 修改用户组
     *
     * @param groupVO
     * @return
     */
    @ApiOperation(value = "修改用户组信息", notes = "修改用户组信息")
    @PostMapping(value = "/update")
    public Response<String> update(@RequestBody UserGroupVO groupVO) {
        try {
            if (null == groupVO) {
                throw new BizException(ReturnCode.PARAM_INVALID.getCode(), ReturnCode.PARAM_INVALID.getMsg());
            }
            if (null == groupVO.getId()) {
                throw new BizException(ReturnCode.PARAM_INVALID.getCode(), ReturnCode.PARAM_INVALID.getMsg());
            }
            groupVO.setCompanyId(ContextHolder.get().getCompanyId());
            com.yizhi.system.application.domain.AuthzUserGroup group = (com.yizhi.system.application.domain.AuthzUserGroup) converter.toDO(groupVO, com.yizhi.system.application.domain.AuthzUserGroup.class);
            group.setAccountIds(groupVO.getAccountIds());

            // 如果用户组的范围被更改了，清除相关管理员的权限cache
            boolean clearCacheFlag = true;
            Set<Long> memberIds = groupMemberService.getMemberIdsByGroupId(groupVO.getId());
            groupService.update(group);

            // 当前传入的member id集合
            Set<Long> targetSet = new HashSet<>();
            if (CollectionUtils.isNotEmpty(groupVO.getOrgIds())) {
                targetSet.addAll(groupVO.getOrgIds());
            }
            if (CollectionUtils.isNotEmpty(groupVO.getAccountIds())) {
                targetSet.addAll(groupVO.getAccountIds());
            }

            if (CollectionUtils.isEmpty(memberIds) && CollectionUtils.isEmpty(targetSet)) {
                clearCacheFlag = false;
            } else if ((CollectionUtils.isEmpty(memberIds) && CollectionUtils.isNotEmpty(targetSet)
                    || (CollectionUtils.isNotEmpty(memberIds) && CollectionUtils.isEmpty(targetSet)))) {
                clearCacheFlag = true;
            } else if (CollectionUtils.isEqualCollection(memberIds, targetSet)) {
                clearCacheFlag = false;
            }

            if (clearCacheFlag) {
                com.yizhi.system.application.domain.Site site = new com.yizhi.system.application.domain.Site();
                site.setId(ContextHolder.get().getSiteId());
                site = site.selectById();
                groupService.deleteAccountAuthzInfo(ContextHolder.get().getCompanyCode(), site.getCode(), groupVO.getId());
            }
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 删除用户组
     *
     * @param groupVO
     * @return
     */
    @ApiOperation(value = "删除用户组信息", notes = "删除用户组信息")
    @PostMapping(value = "/delete")
    public Response<String> delete(@RequestBody UserGroupVO groupVO) {
        try {
            if (null == groupVO) {
                throw new BizException(ReturnCode.PARAM_INVALID.getCode(), ReturnCode.PARAM_INVALID.getMsg());
            }
            if (null == groupVO.getId()) {
                throw new BizException(ReturnCode.PARAM_INVALID.getCode(), ReturnCode.PARAM_INVALID.getMsg());
            }

            com.yizhi.system.application.domain.AuthzGroupMember gm = new com.yizhi.system.application.domain.AuthzGroupMember();
            gm.setGroupId(groupVO.getId());
            gm.setDeleted(0);
            int count = gm.selectCount(new EntityWrapper(gm));
            if (count > 0) {
                return Response.fail("4001", InternationalEnums.GROUPCONTROLLER1.getCode());
            }
            groupService.delete(groupVO.getId());
            // 清除权限cache
            com.yizhi.system.application.domain.Site site = new com.yizhi.system.application.domain.Site();
            site.setId(ContextHolder.get().getSiteId());
            site = site.selectById();
            groupService.deleteAccountAuthzInfo(ContextHolder.get().getCompanyCode(), site.getCode(), groupVO.getId());
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 查询用户组
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "查找用户组信息", notes = "查找用户组信息")
    @GetMapping(value = "/get")
    public Response<UserGroupVO> findById(@RequestParam(name = "id") Long id) {
        try {
            com.yizhi.system.application.domain.AuthzUserGroup group = groupService.findById(id);
            UserGroupVO vo = (UserGroupVO) converter.toVO(group, UserGroupVO.class);
            if (CollectionUtils.isNotEmpty(group.getAccountIds())) {
                vo.setAccountVOs(converter.toVOList(accountService.selectBatchIds(group.getAccountIds()), AccountVO.class));
            }
            if (CollectionUtils.isNotEmpty(group.getOrgIds())) {
                com.yizhi.system.application.domain.Organization example = new com.yizhi.system.application.domain.Organization();
                example.setDeleted(Boolean.valueOf(false));
                EntityWrapper<com.yizhi.system.application.domain.Organization> ew = new EntityWrapper<>();
                ew.in("id", group.getOrgIds());
                List<com.yizhi.system.application.domain.Organization> organizations = orgService.selectList(ew);
                if (!CollectionUtils.isEmpty(organizations)) {
                    List<com.yizhi.system.application.domain.Organization> orgs = new ArrayList<>();
                    for (Organization o : organizations) {
                        if (!group.getOrgIds().contains(o.getParentId())) {
                            if (!orgs.contains(o)) {
                                orgs.add(o);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(orgs)) {
                        vo.setOrgVOs(converter.toVOList(orgs, OrgVO.class));
                    }
                }
            }
            return Response.ok(vo);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 查询用户组列表
     *
     * @return
     */
    @ApiOperation(value = "查询用户组列表", notes = "查询用户组列表")
    @GetMapping(value = "/list")
    public Response<UserGroupVO> list() {
        try {
            UserGroupVO groupVO = new UserGroupVO();
            groupVO.setCompanyId(ContextHolder.get().getCompanyId());
            groupVO.setSiteId(ContextHolder.get().getSiteId());
            List<com.yizhi.system.application.domain.AuthzUserGroup> groups;
            if (ContextHolder.get().isAdmin()) {
                groups = groupService.list((com.yizhi.system.application.domain.AuthzUserGroup) converter.toDO(groupVO, com.yizhi.system.application.domain.AuthzUserGroup.class), null);
            } else {
                groups = groupService.list((com.yizhi.system.application.domain.AuthzUserGroup) converter.toDO(groupVO, com.yizhi.system.application.domain.AuthzUserGroup.class), ContextHolder.get().getAccountId());
            }
            if (CollectionUtils.isEmpty(groups)){
                //数据为null时，前端强制要求为空数组；
                return Response.ok(new ArrayList<>());
            }
            return Response.ok((List<UserGroupVO>) converter.toVOList(groups, UserGroupVO.class));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 分页查询用户组列表
     *
     * @param groupVO
     * @return
     */
    @ApiOperation(value = "分页查询用户组列表", notes = "分页查询用户组列表")
    @PostMapping(value = "/list/page")
    public Response<UserGroupVO> listByPage(@RequestBody UserGroupPageVO groupVO) {
        try {
            com.yizhi.system.application.domain.AuthzUserGroup group = (com.yizhi.system.application.domain.AuthzUserGroup) converter.toDO(groupVO, com.yizhi.system.application.domain.AuthzUserGroup.class);
            group.setCompanyId(ContextHolder.get().getCompanyId());
            group.setSiteId(ContextHolder.get().getSiteId());
            PageInfo<com.yizhi.system.application.domain.AuthzUserGroup> pageInfo = new PageInfo<>();
            pageInfo.setPageNo(groupVO.getPageNo());
            pageInfo.setPageSize(groupVO.getPageSize());
            Page<com.yizhi.system.application.domain.AuthzUserGroup> page = groupService.listByPage(group, PageUtil.vice(pageInfo));
            return Response.ok(PageUtil.versa(converter.toPageVO(page, UserGroupVO.class)));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 检查名称是否存在
     *
     * @param name
     * @return
     */
    @ApiOperation(value = "检查用户组name是否存在", notes = "检查用户组name是否存在")
    @GetMapping(value = "/check/name")
    public Response<Boolean> checkName(@RequestParam(name = "name") String name) {
        try {
            groupService.checkName(0L, name, ContextHolder.get().getCompanyId(), ContextHolder.get().getSiteId());
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 检查名称是否存在
     *
     * @param seachVal
     * @return
     */
    @ApiOperation(value = "根据名称模糊搜索指定范围的用户组", notes = "根据名称模糊搜索指定范围的用户组", response = UserGroupVO.class)
    @GetMapping(value = "/name/seach")
    public Response<List<UserGroupVO>> listByNames(@ApiParam(value = "要查询的用户组名称")
                                                   @RequestParam String seachVal) {
        Long siteId = ContextHolder.get().getSiteId();
        logger.info("当前站点=" + siteId);
        EntityWrapper<com.yizhi.system.application.domain.AuthzUserGroup> condition = QueryUtil.condition(new com.yizhi.system.application.domain.AuthzUserGroup());
        condition.where("deleted={0}", "0").and("site_id={0}", siteId)
                .and().like("name", seachVal, SqlLike.DEFAULT);
        List<com.yizhi.system.application.domain.AuthzUserGroup> ret = groupService.selectList(condition);
        List<UserGroupVO> tmpRet = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(ret)) {
            for (com.yizhi.system.application.domain.AuthzUserGroup obj : ret) {
                UserGroupVO userGroupVO = new UserGroupVO();
                BeanUtils.copyProperties(obj, userGroupVO);
                tmpRet.add(userGroupVO);
            }
        }
        return Response.ok(tmpRet);
    }

    @ApiOperation(value = "获取管辖区关联人数")
    @GetMapping(value = "/accountNum/get")
    public Response<Integer> getGroupAccountNum(@ApiParam("管辖区id") @RequestParam Long groupId) {
        try {
            return Response.ok(groupService.getGroupAccountNum(ContextHolder.get().getCompanyId(), groupId));
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail("", e.getMessage());
        }
    }

    @ApiOperation(value = "用户导出")
    @GetMapping(value = "/account/export")
    public Response<String> exportGroup(@ApiParam("管辖区id") @RequestParam Long groupId) {
        try {
            com.yizhi.system.application.domain.AuthzUserGroup group = groupService.selectById(groupId);
            if (null == group) {
                return Response.fail("4001", "未找到该管辖区！");
            }
            Map<String, List<Long>> map = groupService.getOrgIdAndAccountIdByGroupId(groupId);
            if (map != null) {
                List<Long> orgIds = map.get("orgIds");
                List<Long> accountIds = map.get("accountIds");
                AccountRangeExportParam param = new AccountRangeExportParam();
                param.setContext(ContextHolder.get());
                param.setBizName("管辖区 - " + group.getName());
                param.setOrgIds(orgIds);
                param.setAccountIds(accountIds);
                return Response.ok(accountRangeExportService.doExport(param, "GROUP-USER-EXPORT-", "用户导出"));
            }
            return Response.fail("4001", InternationalEnums.GROUPCONTROLLER3.getCode());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail("", e.getMessage());
        }
    }

    @ApiOperation(value = "管辖区可见范围导入", notes = "管辖区可见范围导入")
    @PostMapping("/groupMember/import")
    public Response<Object> groupMemberRangeImport(@RequestBody RangeImportParamVo rangeImportParamVo) {
        com.yizhi.system.application.domain.AuthzUserGroup group = groupService.selectById(rangeImportParamVo.getBizdId());
        if (null == group) {
            return Response.fail("4001", InternationalEnums.GROUPCONTROLLER2.getCode());
        }

        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "GROUPMEMBER-RANGE-IMPORT-" + taskId.toString();
        String taskName = "管辖区可见范围导入-" + taskId.toString();
        String ossUrl = rangeImportParamVo.getOssUrl();
        Long groupId = rangeImportParamVo.getBizdId();
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
//        res.setCompanyId(1314l);
//        res.setSiteId(1314l);
//        res.setAccountId(1314l);
//        res.setAccountName("taoge   ");
        map.put("ossUrl", ossUrl);
        map.put("requestContext", res);
        map.put("groupId", groupId);
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        groupMemberImport.execute(map, true);
        return Response.ok("任务序号:" + serialNo + ",任务名称:" + taskName);

    }
}
