package com.yizhi.system.application.controller.remote;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.system.application.service.using.OrganizationCacheService;
import com.yizhi.system.application.domain.Company;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author: shengchenglong
 * @Date: 2018/8/10 15:58
 */
@RestController
@RequestMapping("/remote/company/scheduler")
public class CompanyStructureSchedulerController {

    private static final Logger LOGGER = LoggerFactory.getLogger(CompanyStructureSchedulerController.class);

    @Autowired
    private OrganizationCacheService organizationCacheService;

    @GetMapping("buildCompanyStructure")
    public boolean buildCompanyStructure() throws Exception {
        Company companyExample = new Company();
        companyExample.setStatus(2);
        List<Company> companies = companyExample.selectList(new EntityWrapper(companyExample));

        if (CollectionUtils.isNotEmpty(companies)) {

            LOGGER.info("--------------Redis操作：准备重置所有企业、组织、站点 信息--------------");
            LOGGER.debug("--------------Redis操作：3--------------");
            LOGGER.debug("--------------Redis操作：2--------------");
            LOGGER.debug("--------------Redis操作：1--------------");

            long startTime;
            for (Company company : companies) {
                startTime = System.currentTimeMillis();

                // 企业信息
                organizationCacheService.cacheCompany(company);

                // 组织信息
                organizationCacheService.cacheCompanyOrganization(company);

                // 站点信息
                organizationCacheService.cacheSite(company, true);

                LOGGER.info("--------------Redis操作：重置所有企业、组织、站点 信息，完成，耗时：{} 毫秒--------------", System.currentTimeMillis() - startTime);
            }
        }
        return true;
    }

}
