package com.yizhi.system.application.controller.remote;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.system.application.mapper.OrganizationMapper;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.service.using.OrganizationIndexService;
import com.yizhi.system.application.util.CollectionUtil;
import com.yizhi.system.application.service.*;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.system.application.vo.OrgVO;
import com.yizhi.system.application.vo.UpOrgVO;
import com.yizhi.system.application.vo.UserGroupVO;
import com.yizhi.system.application.vo.WeChatUpdateOrganizationVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.web.bind.annotation.*;

import java.text.DateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 组织部门远程调用接口
 *
 * @author yinyuyan
 */
@RestController
@RequestMapping(value = "/remote")
@Slf4j
public class RemoteOrganizationController {

    private static final Logger LOG = LoggerFactory.getLogger(RemoteOrganizationController.class);

    @Autowired
    IOrganizationService orgService;
    @Autowired
    IAuthzUserGroupService groupService;
    @Autowired
    DomainConverter converter;
    @Autowired
    AuthorityService authorityService;
    @Autowired
    private TaskExecutor executor;
    @Autowired
    private OrganizationIndexService organizationIndexService;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private IUserWechatService userWechatService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private OrganizationMapper organizationMapper;

    @GetMapping(value = "/org/name/search")
    public List<OrgVO> fuzzySearchOrgByName(String name, Long companyId) {
        List<OrgVO> ret = converter.toDOList(orgService.fuzzySearchByName(name, companyId), OrgVO.class);
        LOG.info("根据部门名称模糊查询部门ID的条数=" + (ret == null ? 0 : ret.size()));
        return ret;
    }

    @RequestMapping(value = "/org/pid/search", method = RequestMethod.GET)
    public List<com.yizhi.system.application.vo.domain.Organization> selectAllByPId(@RequestParam("pId") Long pId){
        if (pId==null){
            return null;
        }
        Organization organization=new Organization();
        organization.setId(pId);
        organization=organization.selectById();
        EntityWrapper<Organization> wrapper = new EntityWrapper<>();
        wrapper.gt("left_index",organization.getLeftIndex());
        wrapper.lt("right_index",organization.getRightIndex());
        wrapper.eq("company_id",organization.getCompanyId());
        wrapper.eq("deleted",0);
        List<Organization> list = orgService.selectList(wrapper);
        List<com.yizhi.system.application.vo.domain.Organization> list1= new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            for (Organization o:list
                 ) {
                com.yizhi.system.application.vo.domain.Organization or=new com.yizhi.system.application.vo.domain.Organization();
                BeanUtils.copyProperties(o,or);
                list1.add(or);
            }
        }
        return list1;
    }
    @PostMapping(value = "/org/ids/list")
    public List<OrgVO> listByOrgIds(@RequestBody List<Long> ids) {
        return converter.toDOList(orgService.selectBatchIds(ids), OrgVO.class);
    }

    @PostMapping(value = "/group/ids/list")
    public List<UserGroupVO> listByGroupIds(@RequestBody List<Long> ids) {
        return converter.toDOList(groupService.selectBatchIds(ids), UserGroupVO.class);
    }

    @GetMapping(value = "/org/child/ids")
    public List<Long> getChildIds(@RequestParam("orgId") Long orgId, @RequestParam("companyId") Long companyId) {
        Set<Long> orgIds = organizationService.listChildrenId(CollectionUtil.getArrayList(orgId));
        if (!CollectionUtils.isEmpty(orgIds)) {
            return new ArrayList<>(orgIds);
        }
        return null;
    }

    @GetMapping(value = "/org/chief/names")
    public List<String> getChiefOrgNames(@RequestParam("orgId") Long orgId, @RequestParam("companyId") Long companyId) {
//        String orgNames = "";
//        List<Long> ret = authorityService.getChiefOrgIds(orgId, companyId);
//        LOG.info("根据orgId=" + orgId + ",companyId=" + companyId + "查询出来的父节点=" + JSON.toJSONString(ret));
//        if (CollectionUtils.isNotEmpty(ret)) {
//            EntityWrapper<Organization> where = QueryUtil.condition(new Organization());
//            where.where("1 = {0}", 1).and().in("id", ret).orderBy("layer");
//            List<Organization> selectRet = orgService.selectList(where);
//            if (CollectionUtils.isNotEmpty(selectRet)) {
//                LOG.info("查询站点信息列表=" + JSON.toJSONString(ret));
//                for (Organization orgItem : selectRet) {
//                    orgNames += orgItem.getName() + SystemCommCode.CHIEF_ORG_SPILT.getCode();
//                }
//                orgNames = orgNames.substring(0, orgNames.length() - 2);
//            }
//        }
//        LOG.info("找出学员所在的组织，包括他的所有上级组织 === " + orgNames);
//        return Arrays.asList(orgNames.split(SystemCommCode.CHIEF_ORG_SPILT.getCode()));

        String org = null;
        List<String> orgNames = new ArrayList<>();
        org = organizationService.getOrganizationNames(orgId);
        if (StringUtils.isNotBlank(org)) {
            orgNames = Arrays.asList(org.split(","));
        }

        return orgNames;
    }

    @GetMapping(value = "/orgId/keyword")
    public List<Long> findOrgIdByNameOrCode(@RequestParam("key") String key,
                                            @RequestParam("companyId") Long companyId) {
        Organization org = new Organization();
        org.setCompanyId(companyId);
        EntityWrapper<com.yizhi.system.application.domain.Organization> ew = QueryUtil.condition(new com.yizhi.system.application.domain.Organization());
        ew.where("company_id={0}", companyId);
        ew.andNew().like("code", key, SqlLike.DEFAULT).or().like("name", key, SqlLike.DEFAULT);
        List<com.yizhi.system.application.domain.Organization> findData = orgService.selectList(ew);
        if (CollectionUtils.isNotEmpty(findData)) {
            return findData.stream().map(obj -> obj.getId()).collect(Collectors.toList());
        }
        return null;
    }

    @GetMapping(value = "/orgId/nameKeyword")
    public List<Long> findOrgIdByName(@RequestParam("key") String key,
                                      @RequestParam("companyId") Long companyId) {
        Organization org = new Organization();
        org.setCompanyId(companyId);
        EntityWrapper<Organization> ew = QueryUtil.condition(new Organization());
        ew.where("company_id={0}", companyId);
        ew.andNew().like("name", key, SqlLike.DEFAULT);
        List<Organization> findData = orgService.selectList(ew);
        if (CollectionUtils.isNotEmpty(findData)) {
            return findData.stream().map(obj -> obj.getId()).collect(Collectors.toList());
        }
        return null;
    }

    @PostMapping(value = "/orgId/upOrgs")
    public Map<Long, UpOrgVO> findupOrgsByOrgId(@RequestBody List<Long> orgIds) {
        Map<Long, UpOrgVO> retData = null;
        List<UpOrgVO> ret = orgService.findupOrgsByOrgId(orgIds);
        if (CollectionUtils.isNotEmpty(ret)) {
            retData = ret.stream().collect(Collectors.toMap(key -> key.getId(), val -> val));
        }
        return retData;
    }

    /**
     * 根据组织id查询该组织的父级组织集合
     *
     * @param orgId
     * @return
     */
    @GetMapping(value = "/orgId/parentIds")
    public List<Long> IOrganizationService(@RequestParam("orgId") Long orgId) {
        Set<Long> ret = orgService.listParentIds(orgId);
        if (CollectionUtils.isNotEmpty(ret)) {
            return new ArrayList<>(ret);
        }
        return null;
    }

    /**
     * 根据组织id查询该组织的父级组织集合
     *
     * @param orgIds
     * @return
     */
    @PostMapping(value = "/orgIds/parentNames")
    public Map<Long, List<String>> selectOrgsParentOrgs(@RequestBody List<Long> orgIds) {
        Map<Long, List<String>> data = null;
        if (CollectionUtils.isNotEmpty(orgIds)) {
            data = new HashMap<>();
            for (Long orgId : orgIds) {
                List<String> ret = orgService.listParentNameIds(orgId);
                if (CollectionUtils.isNotEmpty(ret)) {
                    data.put(orgId, ret);
                }
            }
        }
        return data;
    }

    @GetMapping("/org/getChildIds")
    public Set<Long> getChildIds(@RequestParam("orgId") Long orgId) {
        return organizationService.listChildrenId(CollectionUtil.getArrayList(orgId));
    }

    @PostMapping("/org/ids/parent/combineNames")
    public Map<Long, String> getParentNameWithCurrentName(@RequestBody List<Long> orgIds) {
        return orgService.getParentNameWithCurrentName(orgIds);
    }

    @PostMapping("/org/index/rebuild")
    public Boolean rebuildOrgIndex(@RequestBody ArrayList<String> companyCodes) {
        executor.execute(() -> {
            if (CollectionUtils.isNotEmpty(companyCodes)) {
                LOG.info("------------开始 部门 重新建立索引，涉及相关企业：{}---------------", companyCodes);
                companyCodes.forEach(item -> {
                    long companyId = organizationIndexService.initLeftRight(item);
                    organizationIndexService.initParentIdLayer(companyId);
                });
                LOG.info("------------完成 部门 重新建立索引，涉及相关企业：{}---------------", companyCodes);
            } else {
                LOG.info("------------开始 部门 重新建立索引，涉及相关企业：全部---------------");
                List<Company> companies = companyService.selectList(new EntityWrapper<>());
                if (CollectionUtils.isNotEmpty(companies)) {
                    companies.forEach(item -> {
                        LOG.info("------------开始 重新建立全部索引，进度到达企业：{}---------------", item.getCode());
                        organizationIndexService.initLeftRight(item.getId());
                        organizationIndexService.initParentIdLayer(item.getId());
                        LOG.info("------------完成 重新建立全部索引，进度到达企业：{}---------------", item.getCode());
                    });
                }
                LOG.info("------------完成 部门 重新建立索引，涉及相关企业：全部---------------");
            }
        });
        return true;
    }

    @GetMapping("/org/index/rebuild/job")
    public Boolean rebuildOrgIndexJob(@RequestParam Long companyId) {
        Company company = companyService.selectById(companyId);
        if (company == null){
            LOG.error("------------部门 重新建立索引异常 JOB,该公司无效，涉及相关企业：{}---------------", companyId);
        }
        executor.execute(() -> {
            LOG.info("------------开始 部门 重新建立索引 JOB，涉及相关企业：{}---------------", companyId);
            organizationIndexService.initLeftRight(companyId);
            organizationIndexService.initParentIdLayer(companyId);
            LOG.info("------------完成 部门 重新建立索引 JOB，涉及相关企业：{}---------------", companyId);
        });
        return true;
    }

    @GetMapping("/org/getOrgNames")
    public Map<Long, String> getOrgNames(@RequestParam("orgIds") List<Long> orgIds) {
        return organizationService.getOrgNamesByOrgIds(orgIds);
    }

    @GetMapping("/org/getOrgIds")
    public Set<Long> getOrgIdsInSite(@RequestParam("siteId") Long siteId, @RequestParam("companyCode") String companyCode, @RequestParam("siteCode") String siteCode) {
        return organizationService.getOrgIdsInSite(siteId, companyCode, siteCode);
    }

    @GetMapping("/getAccountOrgFullNameList")
    public Map<Long, String> getAccountOrgFullNameMap(@RequestParam(name = "companyId") Long companyId) {

        // 部门 id ： name(code) map集合
        Map<Long, String> orgNameMap = new HashMap<>();
        Map<Long, String> orgFullNameMap = new HashMap<>();
        Map<Long, String> orgCodeMap = new HashMap<>();

        // 公司下部门名称 map
        Organization organization = new Organization();
        organization.setDeleted(Boolean.valueOf(false));
        organization.setCompanyId(companyId);
        List<Organization> organizations = organizationService.selectList(new EntityWrapper<>(organization));

        for (Organization o : organizations) {
            orgNameMap.put(o.getId(), o.getName());
            orgCodeMap.put(o.getId(), o.getCode());
        }

        // 组装部门全名称
        String[] parentIdLayerArr = null;
        for (Organization o : organizations) {
            parentIdLayerArr = o.getParentIdLayer().split("_");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parentIdLayerArr.length; i++) {
                if (i == 0) {
                    sb.append(orgNameMap.get(Long.valueOf(parentIdLayerArr[i])));
                } else {
                    sb.append("+").append(orgNameMap.get(Long.valueOf(parentIdLayerArr[i])));
                }
                orgFullNameMap.put(o.getId(), sb.toString());
            }
        }
        LOG.info("返回的全部组织列表名称：{}", JSON.toJSON(orgFullNameMap));
        return orgFullNameMap;
    }

    /**
     * 用于企业微信更新部门信息
     *
     * @param vo
     * @return
     */
    @PostMapping("/weChat/update/organization")
    public WeChatUpdateOrganizationVo updateOrganization(@RequestBody WeChatUpdateOrganizationVo vo) {
        vo = userWechatService.weChatUpdateOrganization(vo);
        return vo;
    }

    /**
     * 社群org同步
     * @param date
     * @return
     */
    @PostMapping(value="/public/community/syncOrg")
    public List<Organization> syncOrg(@RequestParam("indexTime") long indexTime){
        log.info("===================社群org同步==========================");
        EntityWrapper<Organization> wrapper = new EntityWrapper<>();
        wrapper.gt("index_time", DateUtil.formatDateTime(new Date(indexTime)));
        List<Organization> organizations = organizationService.selectList(wrapper);
        if (CollectionUtils.isEmpty(organizations)){
            return null;
        }
        return organizations;
    }

}
