package com.yizhi.system.application.controller.remote;

import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.system.application.constant.SiteProtectConstants;
import com.yizhi.system.application.domain.SiteProtectNotice;
import com.yizhi.system.application.service.SiteProtectService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

@RestController
@RequestMapping("/system/site/protect")
public class RemoteSiteProtectController {

	@Autowired
	SiteProtectService siteProtectService;

	@Autowired
	RedisCache redisCache;

	/**
	 * 网关使用 根据公司,站点查询关站信息
	 *
	 * @param siteCode
	 * @param companyCode
	 * @return
	 */
	@ApiOperation("网关使用 根据公司,站点查询关站信息")
	@GetMapping("/code/{companyCode}/{siteCode}")
	public String findProtectNoticeBySiteCode(@ApiParam("站点code") @PathVariable("siteCode") String siteCode, @ApiParam("公司code") @PathVariable("companyCode") String companyCode) {
		SiteProtectNotice siteProtectNotice = siteProtectService.findProtectNoticeBySiteCode(siteCode, companyCode);
		if (siteProtectNotice == null) {
			return null;
		}
		String message = siteProtectNotice.getMessage();
		//设置缓存时间
		Date now = new Date();

		long l = siteProtectNotice.getEndTime().getTime() - now.getTime();
		redisCache.hset(SiteProtectConstants.SITE_PROTECT_MESSAGE_PREF+companyCode, siteCode, message, l/1000);
		return message;
	}
}
