package com.yizhi.system.application.controller.remote;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Pattern;

import com.alibaba.fastjson.JSON;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.system.application.domain.LoginLog;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.system.application.domain.SwhyKey;
import com.yizhi.system.application.service.using.OrganizationIndexService;
import com.yizhi.system.application.util.SaltUtil;
import com.yizhi.system.application.vo.SaltAccountVO;
import com.yizhi.system.application.vo.SaltPlusAccountVO;
import com.yizhi.system.application.vo.UpdateAccountReqVO;
import com.yizhi.system.application.vo.UpdateAccountVO;
import com.yizhi.system.application.vo.domain.Account;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.event.LogEvent;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.core.application.log.LogEventPublisher;
import com.yizhi.core.application.log.LogQueue;
import com.yizhi.core.application.log.TaskLogDetailEvent;
import com.yizhi.core.application.log.TaskLogEvent;
import com.yizhi.system.application.mapper.AccountMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.ILoginLogService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.service.SwhyKeyService;
import com.yizhi.core.application.token.TokenHelper;
import com.yizhi.util.application.constant.GlobalConstant;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.encrypt.ShaEncrypt;
import com.yizhi.util.application.enums.i18n.Constants;
import com.yizhi.util.application.json.JsonUtil;
import com.yizhi.util.application.regex.RegexUtil;
import com.yizhi.wechat.application.utils.HttpClientUtils;

import javax.annotation.Resource;

/**
 * 第三方用户数据同步接口
 * 
 * @author Administrator
 *
 */
@RestController
@RequestMapping("/public/api")
public class SaltController {

	private static final Logger logger = LoggerFactory.getLogger(SaltController.class);
	
	final Long ACCOUNT_ID = 999L;
	
	/**
	 * 不验证用户名
	 */
	final Integer NO_VALIDATION = 0;
	
	/**
	 * 第三方使用智慧党建的加密规则验证用户名
	 */
	final Integer SALT_VALIDATION = 1;
	
	/**
	 * 智慧党建使用第三方的加密规则验证用户名
	 */
	final Integer OTHER_VALIDATION = 2;
	
	@Autowired
	IAccountService accountService;

	@Autowired
	SwhyKeyService swhyKeyService;

	@Autowired
	TokenHelper tokenHelper;

	@Autowired
	private ILoginLogService loginLogService;

	@Autowired
	IOrganizationService organizationService;

	@Autowired
	RedisCache redisCache;

	@Autowired
	IdGenerator idGenerator;
	
	@Resource
	AccountMapper accountMapper;

	@Autowired
	OrganizationIndexService organizationIndexService;
	
   /* @Autowired
    RabbitTemplate rabbitTemplate;*/
    
    @Autowired
    LogEventPublisher publisher;


    /**
     * 生成sign
     * @param params
     * @param appSecret
     * @param salt
     * @return
     */
	private static String sign(Map<String,String> params, String appSecret , String salt){
        if(org.springframework.util.CollectionUtils.isEmpty(params)){
            return "";
        }
        // 对参数的名字进行排序
        List<String> keyList = new ArrayList<>(params.keySet());
        Collections.sort(keyList);
        StringBuilder sbr = new StringBuilder("{");
        for(String keyStr : keyList){
            sbr.append(keyStr).append("=").append(StringUtils.trimToEmpty(params.get(keyStr))).append("&");
        }
        String paramsStr = sbr.toString()+"secret="+appSecret+"}";
        String signStr = salt+paramsStr;

		logger.info("拼接参数字符串={}", signStr);
		String retStr = ShaEncrypt.getSHA256Str(signStr);
		logger.info("拼接参数字符串,进行sha签名={}", retStr);
        return retStr;
    }


    @PostMapping("/plus/getAccount")
	public Response<String> getAccountPlus(@RequestBody SaltPlusAccountVO saltPlusAccountVO) {
		logger.info("--------------------- salt getAccount ------------------------");
		logger.info("请求参数={}", JSON.toJSONString(saltPlusAccountVO));
        RequestContext context = ContextHolder.get();
		// 生成sign，验证请求是否被更改
        Map<String,String> params = new HashMap<>();
        params.put("appid",saltPlusAccountVO.getAppId());
        //params.put("mp",saltPlusAccountVO.getTerminalType().toString());
        params.put("companycode",context.getCompanyCode());
        params.put("sitecode",context.getSiteCode());
        params.put("md5nm",saltPlusAccountVO.getName());
		params.put("token",saltPlusAccountVO.getToken());
        params.put("href_url",saltPlusAccountVO.getHrefUrl());

		// 查询companyId
		com.yizhi.system.application.domain.SwhyKey swhyKey = new com.yizhi.system.application.domain.SwhyKey();
		swhyKey.setUuid(saltPlusAccountVO.getAppId());
		//swhyKey.setCompanyId(context.getCompanyId());
		EntityWrapper<com.yizhi.system.application.domain.SwhyKey> wrapper = new EntityWrapper<com.yizhi.system.application.domain.SwhyKey>(swhyKey);
		com.yizhi.system.application.domain.SwhyKey selectOne = swhyKeyService.selectOne(wrapper);

		if(selectOne == null){
			return Response.fail("传递的appId有误！");
		}

        String salt = saltPlusAccountVO.getSalt();
        //String appSecret = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		String appSecret = selectOne.getAppSecret();
		logger.info("配置的appSecret={}", appSecret);
		String sign = sign(params, appSecret, salt);
        String requestSign = saltPlusAccountVO.getSign();
        if(StringUtils.EMPTY.equals(StringUtils.trimToEmpty(requestSign)) || !requestSign.equals(sign)){
            return Response.fail("签名无效, 无效登录请求！");
        }
        // 请求远程的信息验证
		HttpClientUtils httpClient = HttpClientUtils.getInstance();
        // String remoteUrl = "https://api.r-vision-group.com/UserNew/TokenAuth?md5nm=%s&token=%s&salt=%s&sign=%s";
		String remoteUrl = selectOne.getClientUrl();
		Map<String,String> paramsRemote = new HashMap<>();
		paramsRemote.put("md5nm", saltPlusAccountVO.getName());
		paramsRemote.put("token",saltPlusAccountVO.getToken());
		String requestSignParam = sign(paramsRemote, appSecret, salt);
        remoteUrl = String.format(remoteUrl, saltPlusAccountVO.getName(), saltPlusAccountVO.getToken(),
                saltPlusAccountVO.getSalt(), requestSignParam);
        logger.info("配置的remoteUrl={}", remoteUrl);

		String ret = httpClient.httpGet(remoteUrl);
		logger.info("请求响应={}",ret);
		JSONObject jsonObject = JSONObject.parseObject(ret);
		Object retCode = jsonObject.get("code");
		if(retCode == null || !"0".equals(retCode.toString())){
			Object msg = jsonObject.get("msg");
			logger.info("R+ 令牌验证失败"+ msg==null?"":msg.toString());
			return Response.fail("令牌验证失败！");
		}

		SaltAccountVO saltAccountVO = new SaltAccountVO();
		saltAccountVO.setAppId(saltPlusAccountVO.getAppId());
		saltAccountVO.setName(saltPlusAccountVO.getName());
		saltAccountVO.setSalt(saltPlusAccountVO.getSalt());
		saltAccountVO.setTerminalType(saltPlusAccountVO.getTerminalType());
		saltAccountVO.setType(saltPlusAccountVO.getType());
		return getAccount(saltAccountVO);
	}
	/**
	 *
	 * @param saltAccountVO
	 * @return
	 */
	@PostMapping("/getUserInfo")
	public Response getStaus(@RequestBody SaltAccountVO saltAccountVO) {
		logger.info("--------------------- salt getStaus ------------------------");

		// vo 信息
		String nameString = saltAccountVO.getName(); // 加密的用户名
		String appId = saltAccountVO.getAppId(); // appId
		String salt = saltAccountVO.getSalt(); // 随机盐

		RequestContext context = ContextHolder.get();
		Long companyId = context.getCompanyId();

		if (StringUtils.isEmpty(nameString)) {
			return Response.fail(InternationalEnums.SALTCONTROLLER1.getName());
		}

		String privateKey = "";
		com.yizhi.system.application.domain.Account user = null;

		// 解密数据
		try {

			// 查询companyId
			SwhyKey swhyKey = new SwhyKey();
			swhyKey.setUuid(appId);
			EntityWrapper<SwhyKey> wrapper = new EntityWrapper<>(swhyKey);
			SwhyKey selectOne = swhyKeyService.selectOne(wrapper);
			if (null != selectOne) {
				Date expireTime = selectOne.getExpireTime();
				privateKey = selectOne.getPrivateKey();
				if (System.currentTimeMillis() > expireTime.getTime()) {
					return Response.fail(InternationalEnums.SALTCONTROLLER2.getName());
				}
			} else {
				return Response.fail(InternationalEnums.SALTCONTROLLER2.getName());
			}

			String decryptName = SaltUtil.decrypt(nameString, salt , privateKey);
			if (null == decryptName) {
				return Response.fail(InternationalEnums.SALTCONTROLLER5.getName());
			}

			// 查询用户
			if (null != companyId) {
				com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
				account.setName(decryptName);
				account.setCompanyId(companyId);
				//account.setEnabled(true);
				user = accountService.selectOne(QueryUtil.condition(account));
				if (null == user) {
					return Response.fail(InternationalEnums.SALTCONTROLLER6.getName());
				}
				user.setPassword(null);
				user.setIdNumber(null);
				user.setMobile(null);
				user.setTelephone(null);
			}
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("处理发生异常={}", e);
			return Response.fail(InternationalEnums.SALTCONTROLLER8.getName());
		}
		return Response.ok(user);

	}


	/**
	 * 
	 * @param saltAccountVO
	 * @return
	 */
	@PostMapping("/getAccount")
	public Response<String> getAccount(@RequestBody SaltAccountVO saltAccountVO) {
		
		logger.info("--------------------- salt getAccount ------------------------");
		Long startTime = System.currentTimeMillis();
		
		RequestContext context = ContextHolder.get();
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		Long companyId = context.getCompanyId();
		Long siteId = context.getSiteId();
		String companyCode = context.getCompanyCode();
		String companyName = context.getCompanyName();
		Integer type = saltAccountVO.getType();
		Integer terminalType = saltAccountVO.getTerminalType();
		//转换成PC
		if(terminalType == 4){
			terminalType = 1;
		}
		
		Map<String, Object> retMap = new HashMap<>();
        TaskContext taskContextTemp = new TaskContext(taskId,"获取用户信息", ACCOUNT_ID, submitTime,siteId,companyId);
        TaskLogEvent taskLogEvent = TaskLogEvent.working(taskContextTemp);
        LogEvent<TaskLogEvent> event = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, taskLogEvent);
        List<TaskLogDetailEvent> failEvents = new ArrayList<TaskLogDetailEvent>();
        String nameString = saltAccountVO.getName();
        if (StringUtils.isEmpty(nameString)) {
            publisher.publish(event);
        	failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER1.getName()));
            //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
    		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER1.getName());
    		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
    		publisher.publish(faileEvent);
			return Response.fail(InternationalEnums.SALTCONTROLLER1.getName());
        }
        
        String publicKey = "";
        String privateKey = "";
        com.yizhi.system.application.domain.Account user = null;
        
		// 解密数据
		try {
			String appId = saltAccountVO.getAppId();
			// 查询companyId
			com.yizhi.system.application.domain.SwhyKey swhyKey = new com.yizhi.system.application.domain.SwhyKey();
			swhyKey.setUuid(appId);
			EntityWrapper<com.yizhi.system.application.domain.SwhyKey> wrapper = new EntityWrapper<com.yizhi.system.application.domain.SwhyKey>(swhyKey);
			com.yizhi.system.application.domain.SwhyKey selectOne = swhyKeyService.selectOne(wrapper);
			if (null != selectOne) {
				Date expireTime = selectOne.getExpireTime();
				publicKey = selectOne.getPublicKey();
				privateKey = selectOne.getPrivateKey();
				//companyId = selectOne.getCompanyId();
				if (System.currentTimeMillis() > expireTime.getTime()) {
		            publisher.publish(event);
					failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER2.getName()+appId));
					//rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
		    		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER2.getName()+appId);
		    		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
		    		publisher.publish(faileEvent);
		    		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "查询用户成功","");
		        	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
		    		publisher.publish(successEvent);	
					return Response.fail(InternationalEnums.SALTCONTROLLER2.getName());
				}
				
				//判断企业是否能明文传输用户名(开启白名单)
				if (type == null || type.equals(NO_VALIDATION)) {
					if(selectOne.getRsaState().equals(0)){
			            publisher.publish(event);
						failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER3.getName()));
						//rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
			    		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER3.getName());
			    		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
			    		publisher.publish(faileEvent);
			    		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "查询用户成功","");
			        	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
			    		publisher.publish(successEvent);	
						return Response.fail(InternationalEnums.SALTCONTROLLER3.getName());
					}
				}				
			} else {
	            publisher.publish(event);
				failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER4.getName()+appId));
				//rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
	    		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER4.getName()+appId);
	    		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
	    		publisher.publish(faileEvent);
	    		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "查询用户成功","");
	        	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
	    		publisher.publish(successEvent);	
				return Response.fail(InternationalEnums.SALTCONTROLLER4.getName());
			}
			
	        if (type!=null&&type.equals(SALT_VALIDATION)) {
				String decryptName = SaltUtil.decrypt(saltAccountVO.getName(), saltAccountVO.getSalt(), privateKey);
				if (null == decryptName) {
		            publisher.publish(event);
	                failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER5.getName()+saltAccountVO.getSalt()));
	                //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
	        		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp,InternationalEnums.SALTCONTROLLER5.getName()+saltAccountVO.getSalt());
	        		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
	        		publisher.publish(faileEvent);
	        		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "查询用户成功","");
	            	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
	        		publisher.publish(successEvent);	
					return Response.fail(InternationalEnums.SALTCONTROLLER5.getName());
				}
				nameString = decryptName;
			}
			// 查询用户
			if (null != companyId) {
				com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
				account.setName(nameString);
				account.setCompanyId(companyId);
				account.setEnabled(true);
				user = accountService.selectOne(QueryUtil.condition(account));
				if (null == user) {
		            publisher.publish(event);
	                failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER6.getName()+nameString));
	                //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
	        		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER6.getName()+nameString);
	        		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
	        		publisher.publish(faileEvent);
	        		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "查询用户成功","");
	            	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
	        		publisher.publish(successEvent);	
					return Response.fail(InternationalEnums.SALTCONTROLLER6.getName());
				}
				try {
					//////////////////////////////////////////////////
					Map<String, Object> info = new HashMap<String, Object>();
					info.put(GlobalConstant.ACCOUNT_ID, String.valueOf(user.getId()));
					info.put(GlobalConstant.COMPANY_CODE, companyCode);
					info.put(GlobalConstant.COMPANY_ID, companyId.toString());
					info.put(GlobalConstant.COMPANY_NAME, companyName);

					// 添加站点id
					info.put(GlobalConstant.SITE_ID, siteId.toString());
					context.setAccountId(user.getId());
					context.setOrgId(user.getOrgId());
					String token = tokenHelper.createToken(user.getName(), info);
					user.setPassword(""); 
					 
					// 返回信息
					retMap.put("userInfo", user);
					retMap.put(GlobalConstant.TOKEN_HEADER, token);
					retMap.put("siteId", siteId.toString());
					if (!StringUtils.isBlank(token)) {
						addLoginRecord(user.getId(), companyId, siteId, user.getOrgId(),
								terminalType);
					} else {
			            publisher.publish(event);
		                failEvents.add(new TaskLogDetailEvent(taskId,Constants.MSG_NOT_SITE_ACCESS_AUTH.getName()+user.getName()));
		                //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
		        		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, Constants.MSG_NOT_SITE_ACCESS_AUTH.getName()+user.getName());
		        		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
		        		publisher.publish(faileEvent);
		        		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "查询用户成功","");
		            	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
		        		publisher.publish(successEvent);	
						return Response.fail(Constants.MSG_NOT_SITE_ACCESS_AUTH);
					}
					
				} catch (Exception e) {
					e.printStackTrace();
		            publisher.publish(event);
	                failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER7.getName()));
	                //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
	        		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER7.getName());
	        		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
	        		publisher.publish(faileEvent);
	        		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "查询用户成功","");
	            	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
	        		publisher.publish(successEvent);	
					return Response.fail(InternationalEnums.SALTCONTROLLER7.getName());
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
            publisher.publish(event);
            failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER8.getName()));
            //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
    		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER8.getName());
    		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
    		publisher.publish(faileEvent);
    		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "查询用户成功","");
        	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
    		publisher.publish(successEvent);	
			return Response.fail(InternationalEnums.SALTCONTROLLER8.getName());
		}
		
		Long endTime = System.currentTimeMillis();
		logger.info("--------------------- salt getAccount ------------------------ " + user.getName() + ":" + (endTime - startTime));
		
		return Response.ok(retMap);
	}

	/**
	 * 添加登陆记录
	 */
	private void addLoginRecord(long accountId, long companyId, long siteId, long orgId, int type) {
		// accountService.updateById(account);
		com.yizhi.system.application.domain.LoginLog loginLog = new LoginLog();
		loginLog.setAccountId(accountId);
		loginLog.setCompanyId(companyId);
		loginLog.setSiteId(siteId);
		loginLog.setOrgId(orgId);
		loginLog.setLoginDate(new Date());
		loginLog.setLoginType(type);
		loginLogService.insert(loginLog);

	}

	@SuppressWarnings("unused")
	@PostMapping("/updateAccount")
	public Response<String> updateAccount(@RequestBody UpdateAccountReqVO updateAccountReqVO) {
		RequestContext context = ContextHolder.get();
		
		List<UpdateAccountVO> list = updateAccountReqVO.getAccounts();
		List<String> errorList = new ArrayList<String>();
		String salt = updateAccountReqVO.getSalt();
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
        TaskContext taskContextTemp = new TaskContext(taskId,"批量更新用户信息", ACCOUNT_ID, submitTime, context.getSiteId(), context.getCompanyId());
        TaskLogEvent taskLogEvent = TaskLogEvent.working(taskContextTemp);
        LogEvent<TaskLogEvent> event = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, taskLogEvent);
        publisher.publish(event);
        List<TaskLogDetailEvent> failEvents = new ArrayList<TaskLogDetailEvent>();
		
        String upLoadUrl=null;
		String requestPath=FileConstant.SAVE_PATH;
		File fileDir=new File(requestPath);
		if(!fileDir.exists()) {
			fileDir.mkdir();
		}
		
		StringBuffer fileNameSb = new StringBuffer().append("批量更新用户").append(new SimpleDateFormat("yyyyMMddHHmmss").format(submitTime)).append(".txt");
		String fileName = fileNameSb.toString();
		String path = new StringBuffer().append(requestPath).append(fileNameSb).toString();
		FileOutputStream os=null;
		
		try {

			String appId = updateAccountReqVO.getAppId();
			if (null == appId) {
		        failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER9.getName()+appId));
		        //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
        		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER9.getName()+appId);
        		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
        		publisher.publish(faileEvent);
				return Response.fail(InternationalEnums.SALTCONTROLLER9.getName());
			}
			boolean isNewOrg = false;
			
			// 查询companyId
			com.yizhi.system.application.domain.SwhyKey swhyKey = new com.yizhi.system.application.domain.SwhyKey();
			swhyKey.setUuid(appId);
			EntityWrapper<com.yizhi.system.application.domain.SwhyKey> wrapper = new EntityWrapper<>(swhyKey);
			com.yizhi.system.application.domain.SwhyKey selectOne = swhyKeyService.selectOne(wrapper);
			if (null != selectOne) {
				Date expireTime = selectOne.getExpireTime();
				Long companyId = selectOne.getCompanyId();
				String publicKey = selectOne.getPublicKey();
				String privateKey = selectOne.getPrivateKey();
				//List<String> mobileList = accountMapper.selectMobilesByCompanyId(companyId);
				if (System.currentTimeMillis() > expireTime.getTime()) {
					String error = InternationalEnums.SALTCONTROLLER10.getName();
		            failEvents.add(new TaskLogDetailEvent(taskId, error));
		            //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
	        		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER10.getName());
	        		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
	        		publisher.publish(faileEvent);
					return Response.fail(error);
				}
				if (null != companyId) {
					//查找企业下的根节点
					Long companyParentId = null;
					com.yizhi.system.application.domain.Organization selectOrg = new com.yizhi.system.application.domain.Organization();
					selectOrg.setCompanyId(companyId);
					selectOrg.setParentId(0L);
					EntityWrapper<com.yizhi.system.application.domain.Organization> selectOrgWrapper = new EntityWrapper<>(selectOrg);
					List<com.yizhi.system.application.domain.Organization> selectOrgs = organizationService.selectList(selectOrgWrapper);
					if(CollectionUtils.isNotEmpty(selectOrgs)){
						companyParentId = selectOrgs.get(0).getId();
					}
					
					com.yizhi.system.application.domain.Account accountMobile = new com.yizhi.system.application.domain.Account();
					
					if (null != list && list.size() > 0) {
						
						for (int i = 0; i < list.size(); i++) {
							String name = list.get(i).getName();
							String newName = list.get(i).getNewName();
							String fullName = list.get(i).getFullName();
							String passWord = list.get(i).getPassWord();
							String orgName = list.get(i).getOrgNames();
							String mail = list.get(i).getMail();
							String mobile = list.get(i).getMobile();
							String position = list.get(i).getPosition();
							String sex = list.get(i).getSex();
							String workNum = list.get(i).getWorkNum();
							String idNumber = list.get(i).getIdNumber();
							Long orgId = 0L;
							if (StringUtils.isNotEmpty(name)) {
								String decryptName = SaltUtil.decrypt(name, salt, privateKey);
								if (null == decryptName) {
									String error = InternationalEnums.SALTCONTROLLER11.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER12.getName();
		                            failEvents.add(new TaskLogDetailEvent(taskId, error));
									errorList.add(error);
								}
								String nameString = decryptName;
								com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
								account.setName(nameString);
								account.setEnabled(true);
								account.setCompanyId(companyId);
								com.yizhi.system.application.domain.Account user = accountService.selectOne(QueryUtil.condition(account));
								if (null != user) {
									if (StringUtils.isNotEmpty(newName)) {
										String decryptNewName = SaltUtil.decrypt(newName, salt, privateKey);
										if (null == decryptNewName) {
											String error =  InternationalEnums.SALTCONTROLLER15.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER16.getName();
		                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;
										}
										if(!decryptNewName.equals(decryptName)){
											account.setName(decryptNewName);
											com.yizhi.system.application.domain.Account newUser = accountService.selectOne(QueryUtil.condition(account));
											if (null != newUser) {
												int row = i + 1;
												String error = InternationalEnums.SALTCONTROLLER13.getName() + row + InternationalEnums.SALTCONTROLLER14.getName() + decryptNewName;
												failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
												continue;
											} else {
												user.setName(decryptNewName);
											}
										}

									}
									
									if (StringUtils.isNotEmpty(fullName)) {
										String decryptFullName = SaltUtil.decrypt(fullName, salt, privateKey);
										if (null == decryptFullName) {
											String error =  InternationalEnums.SALTCONTROLLER17.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER18.getName();
		                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;
										} else {
											if (decryptFullName.length()>20) {
												String error =  InternationalEnums.SALTCONTROLLER19.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER20.getName()+decryptFullName;
			                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
												continue;
											}else {
												user.setFullName(decryptFullName);
											}
										}
									}
									
									if (StringUtils.isNotEmpty(passWord)) {
										user.setPassword(passWord);
									} else {
										String error = InternationalEnums.SALTCONTROLLER19.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER21.getName();
		                                failEvents.add(new TaskLogDetailEvent(taskId, error));
										errorList.add(error);
										continue;
									}	
									
									//不对组织加密
									if (StringUtils.isNotEmpty(orgName)) {
										String decryptOrgName = orgName;//SaltUtil.decrypt(orgName, salt, privateKey);
										if (null == decryptOrgName) {
											String error =  InternationalEnums.SALTCONTROLLER22.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER23.getName();
		                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										}
										String orgNameString = decryptOrgName;
										String[] orgStrings = orgNameString.split("\\+");
										Long parentId = companyParentId;
										String parentIdLayer = "";
										if(parentId == null){
											parentId = 0L;
										}
										String newOrgCode = null;
										Map<String, Object> orgMap = new HashMap<String, Object>();
										for (int j = 0; j < orgStrings.length; j++) {
											com.yizhi.system.application.domain.Organization org = new com.yizhi.system.application.domain.Organization();
											org.setName(orgStrings[j]);
											org.setCompanyId(companyId);
//											if (j!=0) {
//												org.setParentId(parentId);
//											}else {
//												org.setParentId(0L);
//											}
											org.setParentId(parentId);
											org.setDeleted(false);
											com.yizhi.system.application.domain.Organization newOrg = organizationService
													.selectOne(QueryUtil.condition(org));
											if (null != newOrg) {
												parentId = newOrg.getId();
												parentIdLayer=newOrg.getParentIdLayer();
												orgMap.put("parentIdLayer", parentIdLayer);
												orgMap.put("parentId", parentId);
												orgMap.put("rootId", newOrg.getRootId());
												if (j == orgStrings.length - 1) {
													orgId=newOrg.getId();
													user.setOrgId(newOrg.getId());
												}
											} else {
//												if (j==0) {
//													String error = "新增解析失败，第" + (i + 1) + "所属根组织错误";
//													failEvents.add(new TaskLogDetailEvent(taskId, error));
//													errorList.add(error);
//													break;
//												}
												isNewOrg = true;
												Long id = idGenerator.generate();
												// 生成组织编码
												// 获取redis中的编码值编码
												String orgCode = redisCache.get(companyId.toString()) + "";
												if (StringUtils.isNotEmpty(orgCode) && !"null".equals(orgCode)) {
													// 新的组织编码
													newOrgCode = (Integer.valueOf(orgCode) + 1) + "";
													// 放到缓存中
													redisCache.set(companyId.toString(), newOrgCode);
												} else {
													newOrgCode = "1";
													redisCache.set(companyId.toString(), newOrgCode);
												}
												String orgNum = "";
												switch (newOrgCode.length()) {
												case 1:
													orgNum = "000" + newOrgCode;
													break;
												case 2:
													orgNum = "00" + newOrgCode;
													break;
												case 3:
													orgNum = "0" + newOrgCode;
													break;
												default:
													orgNum = newOrgCode;
												} 
												org.setCode(orgNum);
												org.setId(id);
												org.setParentId((Long) orgMap.get("parentId"));
												org.setRootId((Long) orgMap.get("rootId"));
												org.setParentIdLayer(orgMap.get("parentIdLayer")+"_"+id);
												if (j == 0) {
													org.setRootId(parentId);
													org.setParentId(parentId);
													org.setParentIdLayer(parentId + "_"+id);
													orgMap.put("rootId", parentId);
													if (j == orgStrings.length - 1) {
														orgId=id;
														user.setOrgId(id);
													}
												} else {
													parentId = id;
													org.setParentId((Long) orgMap.get("parentId"));
													org.setRootId((Long) orgMap.get("rootId"));
													org.setParentIdLayer(orgMap.get("parentIdLayer")+"_"+id);
													if (j == orgStrings.length - 1) {
														orgId=id;
														user.setOrgId(id);
													}
												}
												orgMap.put("parentId", id);
												orgMap.put("parentIdLayer", org.getParentIdLayer());
												org.setLayer(j + 1);
												org.setCreateTime(new Date());
												org.setCreateById(ACCOUNT_ID);
												org.setCompanyId(companyId);
												organizationService.insert(org);
											}
										}
									}
									if (orgId==0) {
										break;
									}
									if (StringUtils.isNotEmpty(mail)) {
										String decryptMail = SaltUtil.decrypt(mail, salt, privateKey);
										if (null == decryptMail) {
											String error =  InternationalEnums.SALTCONTROLLER24.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER25.getName();
		                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											if (!RegexUtil.checkEmail(decryptMail.trim())) {
												String error =  InternationalEnums.SALTCONTROLLER24.getName() + (i + 1) +InternationalEnums.SALTCONTROLLER27.getName();
			                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
						                        continue;
						                    } else {
						                    	user.setEmail(decryptMail);
						                    }
						                }
										
									}
										
									if (StringUtils.isNotEmpty(mobile)) {
										String decryptMobile = SaltUtil.decrypt(mobile, salt, privateKey);
										if (null == decryptMobile) {
											String error =  InternationalEnums.SALTCONTROLLER28.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER29.getName();
		                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;
										} else {
											if (!RegexUtil.checkMobile(decryptMobile.trim())) {
												String error =  InternationalEnums.SALTCONTROLLER28.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER30.getName();
			                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
						                        continue;
						                    }
											
											accountMobile.setMobile(decryptMobile);
											accountMobile.setCompanyId(companyId);
											EntityWrapper<com.yizhi.system.application.domain.Account> wrapperMobile = new EntityWrapper<>(accountMobile);
											List<com.yizhi.system.application.domain.Account> listMobiles = accountService.selectList(wrapperMobile);
											boolean isError = false;
											if(CollectionUtils.isNotEmpty(listMobiles)){
												for(com.yizhi.system.application.domain.Account ac : listMobiles){
										        	if(ac.getMobile().equals(decryptMobile.trim()) && !ac.getName().equals(nameString)){
										        		isError = true;
										        		break;
										        	}
										        }
											}
						                    if (isError) {
												String error =  InternationalEnums.SALTCONTROLLER19.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER31.getName();
			                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
						                        continue;
											}else {
												user.setMobile(decryptMobile);
											}
										}
									}	
									
									if (StringUtils.isNotEmpty(workNum)) {
										String decryptWorkNum = SaltUtil.decrypt(workNum, salt, privateKey);
										if (null == decryptWorkNum) {
											String error = InternationalEnums.SALTCONTROLLER32.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER33.getName();
		                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											String regex = "^([A-Z]|[a-z]|[0-9]|[`~!@#$%^&*()_+-=|{}':;\\[\\]\\\"',\\\\\\\\[\\\\\\\\].<>/?~]){1,40}$";
									    	boolean b = Pattern.matches(regex, decryptWorkNum);
									    	if (!b) {
												String error =  InternationalEnums.SALTCONTROLLER32.getName() + (i + 1) +InternationalEnums.SALTCONTROLLER34.getName();
			                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
						                        continue;
											}else {
												user.setWorkNum(decryptWorkNum);
											}
										}
									}
									
									if (StringUtils.isNotEmpty(sex)) {
										String decryptSex = SaltUtil.decrypt(sex, salt, privateKey);
										if (null == decryptSex) {
											String error =  InternationalEnums.SALTCONTROLLER35.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER36.getName();
		                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											user.setSex(decryptSex);
										}
									}
										
									if (StringUtils.isNotEmpty(position)) {
										String decryptPosition = SaltUtil.decrypt(position, salt, privateKey);
										if (null == decryptPosition) {
											String error =  InternationalEnums.SALTCONTROLLER37.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER38.getName();
		                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											user.setPosition(decryptPosition);
										}
									}
									
									if (StringUtils.isNotEmpty(idNumber)) {
										String decryptIdNumber = SaltUtil.decrypt(idNumber, salt, privateKey);
										if (null == decryptIdNumber) {
											String error =  InternationalEnums.SALTCONTROLLER39.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER40.getName();
		                                    failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											user.setIdNumber(decryptIdNumber);
										}
									}
									accountService.updateById(user);
									logger.info("更新用户："+user);
									
								} else {
									int row = i + 1;
									String error =InternationalEnums.SALTCONTROLLER41.getName() + row + InternationalEnums.SALTCONTROLLER42.getName() + nameString + InternationalEnums.SALTCONTROLLER43.getName();
		                            failEvents.add(new TaskLogDetailEvent(taskId, error));
									errorList.add(error);
									continue;

								}
							} else {
								String error =  InternationalEnums.SALTCONTROLLER19.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER44.getName();
		                        failEvents.add(new TaskLogDetailEvent(taskId, error));
								errorList.add(error);
		                        continue;
							}
						}
					} else {
		                failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER45.getName()));
						errorList.add(InternationalEnums.SALTCONTROLLER45.getName());
					}
				}

				if(isNewOrg){
					//添加组织索引信息 
					try{
						organizationIndexService.addInitTask(companyId);
					} catch(Exception e){
						e.printStackTrace();
		                failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER46.getName()));
						errorList.add(InternationalEnums.SALTCONTROLLER46.getName());
					}
				}
				 
			} else {
		        failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER47.getName()));
				errorList.add(InternationalEnums.SALTCONTROLLER47.getName());
			}
		} catch (Exception e) {
			e.printStackTrace();			
			String error = updateAccountReqVO.getAppId() + InternationalEnums.SALTCONTROLLER80.getName() + e.getMessage();
			logger.info(error);			
		    failEvents.add(new TaskLogDetailEvent(taskId, error));
			errorList.add(error);
		}
		
		try{
			os= new FileOutputStream(path);
			String json = JsonUtil.object2Json(updateAccountReqVO);
			os.write(json.getBytes("UTF-8"));
			//阿里云返回url
			upLoadUrl = OssUpload.upload(path, fileName);
		    failEvents.add(new TaskLogDetailEvent(taskId, upLoadUrl));	        
		} catch(IOException e){
			e.printStackTrace();
			String error = updateAccountReqVO.getAppId() + InternationalEnums.SALTCONTROLLER48.getName() + e.getMessage();
			logger.info(error);
		    failEvents.add(new TaskLogDetailEvent(taskId, "" + error));
			errorList.add(error);
		} finally {
			if (os != null) {
				try {
					os.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		
		if (errorList.size() == 0) {
			errorList.add(InternationalEnums.SALTCONTROLLER86.getName());
            failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER86.getName()));
		}
		
        //错误的信息发送给任务详情表
        if (CollectionUtils.isNotEmpty(failEvents)) {
            //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
        }
		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "批量更新用户成功","");
    	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
		publisher.publish(successEvent);	
		return Response.ok(errorList);
	}

	@PostMapping("/createAccount")
	public Response<String> createAccount(@RequestBody UpdateAccountReqVO updateAccountReqVO) {
		RequestContext context = ContextHolder.get();
		
		List<UpdateAccountVO> list = updateAccountReqVO.getAccounts();
		List<String> errorList = new ArrayList<String>();
		String salt = updateAccountReqVO.getSalt();
		
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
        TaskContext taskContextTemp = new TaskContext(taskId,"批量新增用户", ACCOUNT_ID, submitTime, context.getSiteId(), context.getCompanyId());
        TaskLogEvent taskLogEvent = TaskLogEvent.working(taskContextTemp);
        LogEvent<TaskLogEvent> event = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, taskLogEvent);
        publisher.publish(event);
        List<TaskLogDetailEvent> failEvents = new ArrayList<TaskLogDetailEvent>();
		
        String upLoadUrl=null;
		String requestPath=FileConstant.SAVE_PATH;
		File fileDir=new File(requestPath);
		if(!fileDir.exists()) {
			fileDir.mkdir();
		}
		
		StringBuffer fileNameSb = new StringBuffer().append("批量更新用户").append(new SimpleDateFormat("yyyyMMddHHmmss").format(submitTime)).append(".txt");
		String fileName = fileNameSb.toString();
		String path = new StringBuffer().append(requestPath).append(fileNameSb).toString();
		FileOutputStream os=null;
		
		try {

			String appId = updateAccountReqVO.getAppId();
			if (null == appId) {
				failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER49.getName()));
				//rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
        		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER49.getName()+appId);
        		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
        		publisher.publish(faileEvent);
				return Response.fail(InternationalEnums.SALTCONTROLLER49.getName());
			}
			boolean isNewOrg = false;
			// 查询companyId
			com.yizhi.system.application.domain.SwhyKey swhyKey = new com.yizhi.system.application.domain.SwhyKey();
			swhyKey.setUuid(appId);
			EntityWrapper<com.yizhi.system.application.domain.SwhyKey> wrapper = new EntityWrapper<>(swhyKey);
			com.yizhi.system.application.domain.SwhyKey selectOne = swhyKeyService.selectOne(wrapper);
			if (null != selectOne) {
				Date expireTime = selectOne.getExpireTime();
				Long companyId = selectOne.getCompanyId();
				String privateKey = selectOne.getPrivateKey();
				List<String> mobileList = accountMapper.selectMobilesByCompanyId(companyId);
				if (System.currentTimeMillis() > expireTime.getTime()) {
					String error = InternationalEnums.SALTCONTROLLER50.getName();
					failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER50.getName()));
					//rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
	        		TaskLogEvent failLogEvent = TaskLogEvent.fail(taskContextTemp, InternationalEnums.SALTCONTROLLER50.getName());
	        		LogEvent<TaskLogEvent> faileEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, failLogEvent);
	        		publisher.publish(faileEvent);
					return Response.fail(error);
				}
				if (null != companyId) {
					// 查找企业下的根节点
					Long companyParentId = null;
					com.yizhi.system.application.domain.Organization selectOrg = new com.yizhi.system.application.domain.Organization();
					selectOrg.setCompanyId(companyId);
					selectOrg.setParentId(0L);
					EntityWrapper<com.yizhi.system.application.domain.Organization> selectOrgWrapper = new EntityWrapper<>(selectOrg);
					com.yizhi.system.application.domain.Organization selectOrgs = organizationService.selectOne(selectOrgWrapper);
					if (selectOrgs != null) {
						companyParentId = selectOrgs.getId();
					}
					com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
					Date createDate = new Date();
					if (null != list && list.size() > 0) {
						for (int i = 0; i < list.size(); i++) {
							String name = list.get(i).getName();
							String fullName = list.get(i).getFullName();
							String passWord = list.get(i).getPassWord();
							String orgName = list.get(i).getOrgNames();
							String mail = list.get(i).getMail();
							String mobile = list.get(i).getMobile();
							String position = list.get(i).getPosition();
							String sex = list.get(i).getSex();
							String workNum = list.get(i).getWorkNum();
							String idNumber = list.get(i).getIdNumber();
							Long orgId = 0L;
							if (StringUtils.isNotEmpty(name)) {
								String decryptName = SaltUtil.decrypt(name, salt, privateKey);
								if (null == decryptName) {
									String error = InternationalEnums.SALTCONTROLLER51.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER52.getName();
									failEvents.add(new TaskLogDetailEvent(taskId, error));
									errorList.add(error);
									continue;

								}
								String nameString = decryptName;
								account.setName(nameString);
								account.setCompanyId(companyId);
								account.setEnabled(true);
								int userCount = accountService.selectCount(QueryUtil.condition(account));
								if (userCount == 0) {
									// 新建
									com.yizhi.system.application.domain.Account user = new com.yizhi.system.application.domain.Account();
									user.setCompanyId(companyId);
									user.setId(idGenerator.generate());
									user.setName(decryptName);
									if (StringUtils.isNotEmpty(fullName)) {
										String decryptFullName = SaltUtil.decrypt(fullName, salt, privateKey);
										if (null == decryptFullName) {
											String error = InternationalEnums.SALTCONTROLLER53.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER18.getName();
											failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;
										} else {
											if (decryptFullName.length() > 20) {
												String error = InternationalEnums.SALTCONTROLLER53.getName()+ (i + 1) + InternationalEnums.SALTCONTROLLER20.getName();
												failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
												continue;
											} else {
												user.setFullName(decryptFullName);
											}
										}
									} else {
										String error =InternationalEnums.SALTCONTROLLER57.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER71.getName();
										failEvents.add(new TaskLogDetailEvent(taskId, error));
										errorList.add(error);
										continue;
									}

									if (StringUtils.isNotEmpty(passWord)) {
										user.setPassword(passWord);
									} else {
										String error = InternationalEnums.SALTCONTROLLER54.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER21.getName();
										failEvents.add(new TaskLogDetailEvent(taskId, error));
										errorList.add(error);
										continue;
									}
									// 不对组织加密
									if (StringUtils.isNotEmpty(orgName)) {
										String decryptOrgName = orgName;// SaltUtil.decrypt(orgName,
																		// salt,
																		// privateKey);
										if (null == decryptOrgName) {
											String error = InternationalEnums.SALTCONTROLLER55.getName() + (i + 1) +InternationalEnums.SALTCONTROLLER23.getName();
											failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										}

										String orgNameString = decryptOrgName;
										String[] orgStrings = orgNameString.split("\\+");
										Long parentId = companyParentId;
										if (parentId == null) {
											parentId = 0L;
										}
										String parentIdLayer = "";
										String newOrgCode = null;
										Map<String, Object> orgMap = new HashMap<String, Object>();
										com.yizhi.system.application.domain.Organization org = new com.yizhi.system.application.domain.Organization();
										for (int j = 0; j < orgStrings.length; j++) {
											org.setName(orgStrings[j]);
											org.setCompanyId(companyId);
//											if (j!=0) {
//												org.setParentId(parentId);
//											}else {
//												org.setParentId(0L);
//											}
											org.setParentId(parentId);
											org.setDeleted(false);
											com.yizhi.system.application.domain.Organization newOrg = organizationService
													.selectOne(QueryUtil.condition(org));
											if (null != newOrg) {
												// 查找到部门就设置用户部门信息
												parentId = newOrg.getId();
												parentIdLayer = newOrg.getParentIdLayer();
												orgMap.put("parentIdLayer", parentIdLayer);
												orgMap.put("parentId", parentId);
												orgMap.put("rootId", newOrg.getRootId());
												if (j == orgStrings.length - 1) {
													orgId=newOrg.getId();
													user.setOrgId(newOrg.getId());
												}
											} else {
//												if (j==0) {
//													String error = "新增解析失败，第" + (i + 1) + "所属根组织错误";
//													failEvents.add(new TaskLogDetailEvent(taskId, error));
//													errorList.add(error);
//													break;
//												}
												isNewOrg = true;
												// 新建部门信息
												Long id = idGenerator.generate();
												// 生成组织编码
												// 获取redis中的编码值编码
												String orgCode = redisCache.get(companyId.toString()) + "";
												if (orgCode != null && !"".equals(orgCode) && !"null".equals(orgCode)) {
													// 新的组织编码
													newOrgCode = (Integer.valueOf(orgCode) + 1) + "";
													// 放到缓存中
													redisCache.set(companyId.toString(), newOrgCode);
												} else {
													newOrgCode = "1";
													redisCache.set(companyId.toString(), newOrgCode);
												}
												String orgNum = "";
												switch (newOrgCode.length()) {
												case 1:
													orgNum = "000" + newOrgCode;
													break;
												case 2:
													orgNum = "00" + newOrgCode;
													break;
												case 3:
													orgNum = "0" + newOrgCode;
													break;
												default:
													orgNum = newOrgCode;
												}
												org.setCode(orgNum);
												org.setId(id);
												org.setParentId((Long) orgMap.get("parentId"));
												org.setRootId((Long) orgMap.get("rootId"));
												org.setParentIdLayer(orgMap.get("parentIdLayer") + "_" + id);
												if (j == 0) {
													org.setRootId(parentId);
													org.setParentId(parentId);
													org.setParentIdLayer(parentId + "_"+id);
													orgMap.put("rootId", parentId);
													if (j == orgStrings.length - 1) {
														orgId=id;
														user.setOrgId(id);
													}
												} else {
													parentId = id;
													org.setParentId((Long) orgMap.get("parentId"));
													org.setRootId((Long) orgMap.get("rootId"));
													org.setParentIdLayer(orgMap.get("parentIdLayer") + "_" + id);
													if (j == orgStrings.length - 1) {
														orgId=id;
														user.setOrgId(id);
													}
												}
												orgMap.put("parentId", id);
												orgMap.put("parentIdLayer", org.getParentIdLayer());
												org.setLayer(j + 1);
												org.setCreateTime(createDate);
												org.setCreateById(ACCOUNT_ID);
												org.setCompanyId(companyId);
												organizationService.insert(org);

												// 添加组织索引信息
												organizationIndexService.addInitTask(companyId);
											}
										}
									} else {
										String error =InternationalEnums.SALTCONTROLLER57.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER58.getName();
										failEvents.add(new TaskLogDetailEvent(taskId, error));
										errorList.add(error);
										continue;
									}

									if (orgId==0) {
										break;
									}
									if (StringUtils.isNotEmpty(mail)) {
										String decryptMail = SaltUtil.decrypt(mail, salt, privateKey);
										if (null == decryptMail) {
											String error = InternationalEnums.SALTCONTROLLER72.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER25.getName();
											failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											if (!RegexUtil.checkEmail(decryptMail.trim())) {
												String error = InternationalEnums.SALTCONTROLLER72.getName() + (i + 1) +InternationalEnums.SALTCONTROLLER27.getName();
												failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
												continue;
											} else {
												user.setEmail(decryptMail);
											}
										}
									}

									if (StringUtils.isNotEmpty(mobile)) {
										String decryptMobile = SaltUtil.decrypt(mobile, salt, privateKey);
										if (null == decryptMobile) {
											String error = InternationalEnums.SALTCONTROLLER73.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER29.getName();
											failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											if (!RegexUtil.checkMobile(decryptMobile.trim())) {
												String error = InternationalEnums.SALTCONTROLLER73.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER30.getName();
												failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
												continue;
											}

											if (mobileList.contains(decryptMobile.trim())) {
												String error =InternationalEnums.SALTCONTROLLER57.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER31.getName();
												failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
												continue;
											} else {
												user.setMobile(decryptMobile);
											}
										}
									}

									if (StringUtils.isNotEmpty(workNum)) {
										String decryptWorkNum = SaltUtil.decrypt(workNum, salt, privateKey);
										if (null == decryptWorkNum) {
											String error = InternationalEnums.SALTCONTROLLER74.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER33.getName();
											failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											String regex = "^([A-Z]|[a-z]|[0-9]|[`~!@#$%^&*()_+-=|{}':;\\[\\]\\\"',\\\\\\\\[\\\\\\\\].<>/?~]){1,40}$";
											boolean b = Pattern.matches(regex, decryptWorkNum);
											if (!b) {
												String error = InternationalEnums.SALTCONTROLLER74.getName()+ (i + 1) +InternationalEnums.SALTCONTROLLER34.getName();
												failEvents.add(new TaskLogDetailEvent(taskId, error));
												errorList.add(error);
												continue;
											} else {
												user.setWorkNum(decryptWorkNum);
											}
										}
									}

									if (StringUtils.isNotEmpty(sex)) {
										String decryptSex = SaltUtil.decrypt(sex, salt, privateKey);
										if (null == decryptSex) {
											String error = InternationalEnums.SALTCONTROLLER75.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER36.getName();
											failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											user.setSex(decryptSex);
										}
									}

									if (StringUtils.isNotEmpty(position)) {
										String decryptPosition = SaltUtil.decrypt(position, salt, privateKey);
										if (null == decryptPosition) {
											String error = InternationalEnums.SALTCONTROLLER76.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER38.getName();
											failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											user.setPosition(decryptPosition);
										}
									}

									if (StringUtils.isNotEmpty(idNumber)) {
										String decryptIdNumber = SaltUtil.decrypt(idNumber, salt, privateKey);
										if (null == decryptIdNumber) {
											String error = InternationalEnums.SALTCONTROLLER77.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER40.getName();
											failEvents.add(new TaskLogDetailEvent(taskId, error));
											errorList.add(error);
											continue;

										} else {
											user.setIdNumber(decryptIdNumber);
										}
									}

									user.setCreateById(ACCOUNT_ID);
									user.setCreateTime(new Date());
									user.setCompanyId(companyId);
									accountService.insert(user);
									logger.info("新增用户：" + user);
								} else {
									int row = i + 1;
									String error = InternationalEnums.SALTCONTROLLER57.getName() + row + InternationalEnums.SALTCONTROLLER42.getName() + nameString +InternationalEnums.SALTCONTROLLER78.getName();
									failEvents.add(new TaskLogDetailEvent(taskId, error));
									errorList.add(error);
									continue;

								}
							} else {
								String error =InternationalEnums.SALTCONTROLLER57.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER52.getName();
								failEvents.add(new TaskLogDetailEvent(taskId, error));
								errorList.add(error);
								continue;
							}
						}
					} else {
						errorList.add(InternationalEnums.SALTCONTROLLER79.getName());
						failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER79.getName()));
					}
				}

				if (isNewOrg) {
					// 添加组织索引信息
					try {
						organizationIndexService.addInitTask(companyId);
					} catch (Exception e) {
						e.printStackTrace();
						errorList.add(InternationalEnums.SALTCONTROLLER46.getName());
						failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER46.getName()));
					}
				}

			} else {
				errorList.add(InternationalEnums.SALTCONTROLLER47.getName());
				failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER47.getName()));
			}
		
		} catch (Exception e) {
			e.printStackTrace();
			String error = updateAccountReqVO.getAppId() +InternationalEnums.SALTCONTROLLER80.getName() + e.getMessage();
			logger.info(error);
		    failEvents.add(new TaskLogDetailEvent(taskId, "" + error));
			errorList.add(error);
		}
		
		if (errorList.size() == 0) {
			errorList.add(InternationalEnums.SALTCONTROLLER87.getName());
            failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER87.getName()));
		}
		
		try{
			os= new FileOutputStream(path);
			String json = JsonUtil.object2Json(updateAccountReqVO);
			os.write(json.getBytes(StandardCharsets.UTF_8));
			//阿里云返回url
			upLoadUrl = OssUpload.upload(path, fileName);
		    failEvents.add(new TaskLogDetailEvent(taskId, upLoadUrl));	       
		} catch(IOException e){
			e.printStackTrace();
			String error = updateAccountReqVO.getAppId() + InternationalEnums.SALTCONTROLLER81.getName() + e.getMessage();
			logger.info(error);
		    failEvents.add(new TaskLogDetailEvent(taskId, "" + error));
			errorList.add(error);
		} finally {
			if (os != null) {
				try {
					os.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		
		 //错误的信息发送给任务详情表
        if (CollectionUtils.isNotEmpty(failEvents)) {
            //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
        }
		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "批量新增用户成功","");
    	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
		publisher.publish(successEvent);	
		return Response.ok(errorList);
	}

	@PostMapping("/deleteAccount")
	public Response<String> deleteAccount(@RequestBody UpdateAccountReqVO updateAccountReqVO){
		RequestContext context = ContextHolder.get();
		
		List<UpdateAccountVO> list = updateAccountReqVO.getAccounts();
		List<String> errorList = new ArrayList<String>();
		String salt = updateAccountReqVO.getSalt();
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
        TaskContext taskContextTemp = new TaskContext(taskId,"批量禁用用户", ACCOUNT_ID, submitTime, context.getSiteId(), context.getCompanyId());
        TaskLogEvent taskLogEvent = TaskLogEvent.working(taskContextTemp);
        LogEvent<TaskLogEvent> event = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, taskLogEvent);
        publisher.publish(event);
        List<TaskLogDetailEvent> failEvents = new ArrayList<TaskLogDetailEvent>();
		
        String upLoadUrl=null;
		String requestPath=FileConstant.SAVE_PATH;
		File fileDir=new File(requestPath);
		if(!fileDir.exists()) {
			fileDir.mkdir();
		}
		StringBuffer fileNameSb = new StringBuffer().append("批量更新用户").append(new SimpleDateFormat("yyyyMMddHHmmss").format(submitTime)).append(".txt");
		String fileName = fileNameSb.toString();
		String path = new StringBuffer().append(requestPath).append(fileNameSb).toString();
		FileOutputStream os=null;
		
		try {

			String appId = updateAccountReqVO.getAppId();
			if (null == appId) {
		        failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER59.getName()));
		        //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
				return Response.fail(InternationalEnums.SALTCONTROLLER59.getName());
			}
			// 查询companyId
			com.yizhi.system.application.domain.SwhyKey swhyKey = new com.yizhi.system.application.domain.SwhyKey();
			swhyKey.setUuid(appId);
			EntityWrapper<com.yizhi.system.application.domain.SwhyKey> wrapper = new EntityWrapper<>(swhyKey);
			com.yizhi.system.application.domain.SwhyKey selectOne = swhyKeyService.selectOne(wrapper);
			if (null != selectOne) {
				Date expireTime = selectOne.getExpireTime();
				Long companyId = selectOne.getCompanyId();
				String publicKey = selectOne.getPublicKey();
				String privateKey = selectOne.getPrivateKey();
				//List<String> mobileList = accountMapper.selectMobilesByCompanyId(companyId);
				if (System.currentTimeMillis() > expireTime.getTime()) {
					String error = InternationalEnums.SALTCONTROLLER60.getName();
		            failEvents.add(new TaskLogDetailEvent(taskId, error));
		            //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
					return Response.fail(error);
				}
				com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
				Date createDate = new Date();
				if (CollectionUtils.isNotEmpty(list)) {
					for (int i = 0; i < list.size(); i++) {
						String name = list.get(i).getName();
						if (StringUtils.isNotEmpty(name)) {
							String decryptName = SaltUtil.decrypt(name, salt, privateKey);
							if (null == decryptName) {
								String error = InternationalEnums.SALTCONTROLLER61.getName()+ (i + 1) + InternationalEnums.SALTCONTROLLER52.getName();
				                failEvents.add(new TaskLogDetailEvent(taskId, error));
								errorList.add(error);
								continue;

							}
							String nameString = decryptName;
							account.setName(nameString);
							account.setCompanyId(companyId);
							List<com.yizhi.system.application.domain.Account> accounts = accountService.selectList(QueryUtil.condition(account));
							if (CollectionUtils.isNotEmpty(accounts)) {
								if (accounts.size()==1) {
									accounts.get(0).setEnabled(false);
									accounts.get(0).setUpdateTime(createDate);
									accountMapper.updateById(accounts.get(0));
								}else {
									String error = InternationalEnums.SALTCONTROLLER61.getName() + (i + 1) +InternationalEnums.SALTCONTROLLER42.getName()+nameString+InternationalEnums.SALTCONTROLLER82.getName();
					                failEvents.add(new TaskLogDetailEvent(taskId, error));
									errorList.add(error);
									continue;
								}
							}else {
								String error = InternationalEnums.SALTCONTROLLER61.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER42.getName()+nameString+InternationalEnums.SALTCONTROLLER83.getName();
				                failEvents.add(new TaskLogDetailEvent(taskId, error));
								errorList.add(error);
								continue;
							}
						}
					}
				}
				
			} else {
				errorList.add(InternationalEnums.SALTCONTROLLER47.getName());
		        failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER47.getName()));
			}
		
		} catch (Exception e) {
			e.printStackTrace(); 
			String error = updateAccountReqVO.getAppId() +InternationalEnums.SALTCONTROLLER62.getName() + e.getMessage();
			logger.info(error);
		    failEvents.add(new TaskLogDetailEvent(taskId, error));
			errorList.add(error);
		}
		
		try{
			os= new FileOutputStream(path);
			String json = JsonUtil.object2Json(updateAccountReqVO);
			os.write(json.getBytes(StandardCharsets.UTF_8));
			//阿里云返回url
			upLoadUrl = OssUpload.upload(path, fileName);
		    failEvents.add(new TaskLogDetailEvent(taskId, upLoadUrl));	       
		} catch(IOException e){
			e.printStackTrace();
			String error = updateAccountReqVO.getAppId() + InternationalEnums.SALTCONTROLLER63.getName() + e.getMessage();
			logger.info(error);
		    failEvents.add(new TaskLogDetailEvent(taskId, "" + error));
			errorList.add(error);
		} finally {
			if (os != null) {
				try {
					os.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		} 
		
		if (errorList.size() == 0) {
			errorList.add(InternationalEnums.SALTCONTROLLER84.getName());
            failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER84.getName()));
		}
		
		if (CollectionUtils.isNotEmpty(failEvents)) {
            //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
        }
		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "批量禁用用户成功","");
    	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
		publisher.publish(successEvent);	
		if (!CollectionUtils.isNotEmpty(errorList)) {
			return Response.ok();
		}else {
			return Response.ok(errorList);
		}
	}
	
	@PostMapping("/enableAccount")
	public Response<String> enableAccount(@RequestBody UpdateAccountReqVO updateAccountReqVO){
		RequestContext context = ContextHolder.get();
		
		List<UpdateAccountVO> list = updateAccountReqVO.getAccounts();
		List<String> errorList = new ArrayList<String>();
		String salt = updateAccountReqVO.getSalt();
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
        TaskContext taskContextTemp = new TaskContext(taskId,"批量启用用户", ACCOUNT_ID, submitTime, context.getSiteId(), context.getCompanyId());
        TaskLogEvent taskLogEvent = TaskLogEvent.working(taskContextTemp);
        LogEvent<TaskLogEvent> event = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, taskLogEvent);
        publisher.publish(event);
        List<TaskLogDetailEvent> failEvents = new ArrayList<TaskLogDetailEvent>();
		
        String upLoadUrl=null;
		String requestPath=FileConstant.SAVE_PATH;
		File fileDir=new File(requestPath);
		if(!fileDir.exists()) {
			fileDir.mkdir();
		}
		StringBuffer fileNameSb = new StringBuffer().append("批量更新用户").append(new SimpleDateFormat("yyyyMMddHHmmss").format(submitTime)).append(".txt");
		String fileName = fileNameSb.toString();
		String path = new StringBuffer().append(requestPath).append(fileNameSb).toString();
		FileOutputStream os=null;
		
		try {

			String appId = updateAccountReqVO.getAppId();
			if (null == appId) {
		        failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER64.getName()));
		        //.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
				return Response.fail(InternationalEnums.SALTCONTROLLER64.getName());
			}
			// 查询companyId
			com.yizhi.system.application.domain.SwhyKey swhyKey = new com.yizhi.system.application.domain.SwhyKey();
			swhyKey.setUuid(appId);
			EntityWrapper<com.yizhi.system.application.domain.SwhyKey> wrapper = new EntityWrapper<>(swhyKey);
			SwhyKey selectOne = swhyKeyService.selectOne(wrapper);
			if (null != selectOne) {
				Date expireTime = selectOne.getExpireTime();
				Long companyId = selectOne.getCompanyId();
				String publicKey = selectOne.getPublicKey();
				String privateKey = selectOne.getPrivateKey();
				//List<String> mobileList = accountMapper.selectMobilesByCompanyId(companyId);
				if (System.currentTimeMillis() > expireTime.getTime()) {
					String error =InternationalEnums.SALTCONTROLLER65.getName();
		            failEvents.add(new TaskLogDetailEvent(taskId, error));
		            //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
					return Response.fail(error);
				}
				com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
				Date createDate = new Date();
				if (CollectionUtils.isNotEmpty(list)) {
					for (int i = 0; i < list.size(); i++) {
						String name = list.get(i).getName();
						if (StringUtils.isNotEmpty(name)) {
							String decryptName = SaltUtil.decrypt(name, salt, privateKey);
							if (null == decryptName) {
								String error = InternationalEnums.SALTCONTROLLER66.getName()+ (i + 1) + InternationalEnums.SALTCONTROLLER52.getName();
				                failEvents.add(new TaskLogDetailEvent(taskId, error));
								errorList.add(error);
								continue;

							}
							String nameString = decryptName;
							account.setName(nameString);
							account.setCompanyId(companyId);
							List<com.yizhi.system.application.domain.Account> accounts = accountService.selectList(QueryUtil.condition(account));
							if (CollectionUtils.isNotEmpty(accounts)) {
								if (accounts.size()==1) {
									accounts.get(0).setEnabled(true);
									accounts.get(0).setUpdateTime(createDate);
									accountMapper.updateById(accounts.get(0));
								}else {
									String error = InternationalEnums.SALTCONTROLLER66.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER42.getName()+nameString+InternationalEnums.SALTCONTROLLER82.getName();
					                failEvents.add(new TaskLogDetailEvent(taskId, error));
									errorList.add(error);
									continue;
								}
							}else {
								String error = InternationalEnums.SALTCONTROLLER66.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER42.getName()+nameString+InternationalEnums.SALTCONTROLLER83.getName();
				                failEvents.add(new TaskLogDetailEvent(taskId, error));
								errorList.add(error);
								continue;
							}
						}
					}
				}
				
			} else {
				errorList.add(InternationalEnums.SALTCONTROLLER47.getName());
		        failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER47.getName()));
			}
		
		} catch (Exception e) {
			e.printStackTrace(); 
			String error = updateAccountReqVO.getAppId() + InternationalEnums.SALTCONTROLLER67.getName()+ e.getMessage();
			logger.info(error);
		    failEvents.add(new TaskLogDetailEvent(taskId, error));
			errorList.add(error);
		}
		
		try{
			os= new FileOutputStream(path);
			String json = JsonUtil.object2Json(updateAccountReqVO);
			os.write(json.getBytes(StandardCharsets.UTF_8));
			//阿里云返回url
			upLoadUrl = OssUpload.upload(path, fileName);
		    failEvents.add(new TaskLogDetailEvent(taskId, upLoadUrl));	       
		} catch(IOException e){
			e.printStackTrace();
			String error = updateAccountReqVO.getAppId() + InternationalEnums.SALTCONTROLLER68.getName() + e.getMessage();
			logger.info(error);
		    failEvents.add(new TaskLogDetailEvent(taskId, "" + error));
			errorList.add(error);
		} finally {
			if (os != null) {
				try {
					os.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		} 
		
		if (errorList.size() == 0) {
			errorList.add(InternationalEnums.SALTCONTROLLER85.getName());
            failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER85.getName()));
		}
		
		if (CollectionUtils.isNotEmpty(failEvents)) {
            //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
        }
		TaskLogEvent successLogEvent = TaskLogEvent.success(taskContextTemp, "查询用户成功","");
    	LogEvent<TaskLogEvent> successEvent = new LogEvent<>(LogQueue.TASK_LOG_QUEUE, successLogEvent);
		publisher.publish(successEvent);	
		if (!CollectionUtils.isNotEmpty(errorList)) {
			return Response.ok();
		}else {
			return Response.ok(errorList);
		}
	}
	public void org(String newNameString, String salt, Long companyId, Account user, int i, List<String> errorList,
			String orgCode, String privateKey,Long taskId,List<TaskLogDetailEvent> failEvents) throws Exception {
		try {
			if (StringUtils.isNotEmpty(orgCode)) {
				String decryptOrgCode = SaltUtil.decrypt(orgCode, salt, privateKey);
				String newOrgString = decryptOrgCode;
				if (null == newOrgString) {
					String error = InternationalEnums.SALTCONTROLLER13.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER69.getName()+ orgCode;
	                failEvents.add(new TaskLogDetailEvent(taskId, error));
					errorList.add(error);
					return;
				}
				com.yizhi.system.application.domain.Organization org = new com.yizhi.system.application.domain.Organization();
				org.setCode(newOrgString);
				org.setCompanyId(companyId);
				org.setDeleted(false);
				Organization newOrg = organizationService.selectOne(QueryUtil.condition(org));
				if (null != newOrg) {
					if (null != newNameString) {
						user.setName(newNameString);
					}
					user.setOrgId(newOrg.getId());
					com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
					BeanUtils.copyProperties(user,account);
					accountService.updateById(account);
				} else {
					String error = InternationalEnums.SALTCONTROLLER13.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER70.getName() + decryptOrgCode;
	                failEvents.add(new TaskLogDetailEvent(taskId, error));
					errorList.add(error);
				}
			}
		} catch (Exception e) {
			errorList.add(InternationalEnums.SALTCONTROLLER13.getName() + (i + 1) + InternationalEnums.SALTCONTROLLER69.getName() + orgCode);
            failEvents.add(new TaskLogDetailEvent(taskId, InternationalEnums.SALTCONTROLLER13.getName() + (i + 1) +InternationalEnums.SALTCONTROLLER69.getName() + orgCode));
		}
	}

}
