package com.yizhi.system.application.controller.remote;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.system.application.domain.SwhyKey;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.service.SwhyKeyService;
import com.yizhi.system.application.util.RSAUtil;
import com.yizhi.system.application.vo.RsaAccountVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author hutao123
 * @since 2019-05-07
 */
@RestController
@RequestMapping("/swhyKey")
public class SwhyKeyComtroller {


    @Autowired
    SwhyKeyService swhyKeyService;

    @Autowired
    IAccountService accountService;
    @Autowired
    IOrganizationService organizationService;

    private Logger logger = LoggerFactory.getLogger(SwhyKeyComtroller.class);


    @PostMapping(value = "/getAccount")
    public RsaAccountVo getAccount(@RequestBody RsaAccountVo rsaAccountVo) {


        String encryptName = rsaAccountVo.getName();
        String encryptUuid = rsaAccountVo.getSignature();


        //把参数解密
        String decryptName = null;
        String decryptUuid = null;

        try {
            if (encryptName != null) {
                decryptName = RSAUtil.decrypt(encryptName, RSAUtil.PRIVATE_KEY);
            }
            decryptUuid = RSAUtil.decrypt(encryptUuid, RSAUtil.PRIVATE_KEY);

        } catch (Exception e) {
            e.printStackTrace();

            rsaAccountVo.setErrorMsg("解密过程发生错误！");
            return rsaAccountVo;

        }
        //查询companyId
        com.yizhi.system.application.domain.SwhyKey swhyKey = new com.yizhi.system.application.domain.SwhyKey();
        swhyKey.setUuid(decryptUuid);
        EntityWrapper wrapper = new EntityWrapper(swhyKey);
        com.yizhi.system.application.domain.SwhyKey selectOne = swhyKeyService.selectOne(wrapper);
        if (null != selectOne) {
            Date expireTime = selectOne.getExpireTime();
            Long companyId = selectOne.getCompanyId();
            if (System.currentTimeMillis() > expireTime.getTime()) {

                rsaAccountVo.setErrorMsg("私钥已过期！");
                return rsaAccountVo;
            }

            if (null != companyId) {
                com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
                switch (rsaAccountVo.getType()) {
                    case 1:
                        account.setName(decryptName);
                        break;//代表以工号为参数查询用户信息

                    case 2:
                        account.setIdNumber(decryptName);
                        break;//代表以身份证为参数查询用户信息

                }
                account.setCompanyId(companyId);
                com.yizhi.system.application.domain.Account user = accountService.selectOne(QueryUtil.condition(account));
                if (null == user) {
                    rsaAccountVo.setErrorMsg("数据库不存在该用户！");
                    return rsaAccountVo;
                }
                System.out.println("查询出的用户信息为："+JSON.toJSONString(user));
                try {
                    com.yizhi.system.application.domain.Organization organization = organizationService.selectById(user.getOrgId());
                    //加密数据
                    if (organization == null) {
                        rsaAccountVo.setErrorMsg("该用户没有部门信息！");
                    } else {
                        String orgName = RSAUtil.encrypt(organization.getName(), RSAUtil.PUBLIC_KEY);
                        rsaAccountVo.setOrgName(orgName);
                    }
                    //加密数据
                    String encryptFullName = RSAUtil.encrypt(user.getFullName(), RSAUtil.PUBLIC_KEY);

                    rsaAccountVo.setFullName(encryptFullName);
                    rsaAccountVo.setSignature(null);
                    System.out.println("========rsaAccountVo" + rsaAccountVo);
                    return rsaAccountVo;
                } catch (Exception e) {
                    e.printStackTrace();
                    rsaAccountVo.setErrorMsg("加密过程发生错误！");
                    return rsaAccountVo;
                }
            }
        }
        return rsaAccountVo;
    }


    @PostMapping(value = "/get/AccountList")
    public List<RsaAccountVo> getAccountList(@RequestBody List<RsaAccountVo> rsaAccountVos) {


        Boolean condition = true;
        Boolean expire = false;
        String decryptUuid = null;
        Long companyId = null;

        if (!CollectionUtils.isEmpty(rsaAccountVos)) {
            for (RsaAccountVo vo : rsaAccountVos) {
                String encryptName = vo.getName();
                String encryptUuid = vo.getSignature();

                //把参数解密
                String decryptName = null;

                try {
                    decryptName = RSAUtil.decrypt(encryptName, RSAUtil.PRIVATE_KEY);
                } catch (Exception e) {
                    e.printStackTrace();
                    vo.setErrorMsg("解密过程发生错误！");
                    continue;
                }

                //保证一次请求时，防止多次查库
                if (condition) {
                    try {
                        decryptUuid = RSAUtil.decrypt(encryptUuid, RSAUtil.PRIVATE_KEY);
                    } catch (Exception e) {
                        e.printStackTrace();
                        vo.setErrorMsg("解密过程发生错误！");
                        continue;
                    }
                    condition = false;


                    //查询companyId
                    com.yizhi.system.application.domain.SwhyKey swhyKey = new com.yizhi.system.application.domain.SwhyKey();
                    swhyKey.setUuid(decryptUuid);
                    EntityWrapper wrapper = new EntityWrapper(swhyKey);
                    SwhyKey selectOne = swhyKeyService.selectOne(wrapper);
                    if (null != selectOne) {
                        Date expireTime = selectOne.getExpireTime();
                        companyId = selectOne.getCompanyId();
                        if (System.currentTimeMillis() > expireTime.getTime()) {
                            vo.setErrorMsg("私钥已过期！");
                            expire = true;

                        }
                    }
                }

                if (!expire) {
                    if (null != companyId) {
                        com.yizhi.system.application.domain.Account account = new Account();

                        switch (vo.getType()) {
                            case 1:
                                account.setName(decryptName);
                                break;//代表以工号为参数查询用户信息

                            case 2:
                                account.setIdNumber(decryptName);
                                break;//代表以身份证为参数查询用户信息

                        }
                        account.setCompanyId(companyId);
                        com.yizhi.system.application.domain.Account user = accountService.selectOne(QueryUtil.condition(account));
                        if (null == user) {
                            vo.setErrorMsg("数据库不存在该用户！");

                        } else {
                            try {
                                Organization organization = organizationService.selectById(user.getOrgId());
                                //加密数据
                                if (organization == null) {
                                    vo.setErrorMsg("该用户没有部门信息！");
                                } else {
                                    String orgName = RSAUtil.encrypt(organization.getName(), RSAUtil.PUBLIC_KEY);
                                    vo.setOrgName(orgName);
                                }
                                String encryptFullName = RSAUtil.encrypt(user.getFullName(), RSAUtil.PUBLIC_KEY);

                                vo.setFullName(encryptFullName);
                                vo.setSignature(null);
                                System.out.println("========rsaAccountVo" + vo);
                            } catch (Exception e) {
                                e.printStackTrace();
                                vo.setErrorMsg("加密过程发生错误！");
                                continue;
                            }

                        }
                    } else {
                        vo.setErrorMsg("companyId为null!");
                    }
                }
            }
        }
        return rsaAccountVos;
    }


}

