package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 用户
 * </p>
 *
 * @author moniyin
 * @since 2018-03-12
 */
@Data
@ApiModel(value = "Account", description = "用户")
@TableName("account")
public class Account {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "账号名称")
    private String name;

    @ApiModelProperty(value = "密码")
    private String password;

    @ApiModelProperty(value = "头像")
    @TableField("head_portrait")
    private String headPortrait;

    @ApiModelProperty(value = "是否开通")
    private Boolean enabled;

    @ApiModelProperty(value = "是否锁定")
    private Boolean locked;

    @ApiModelProperty(value = "部门id")
    @TableField("org_id")
    private Long orgId;

    @ApiModelProperty(value = "租户(公司)id")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "座机")
    private String telephone;

    @ApiModelProperty(value = "手机号")
    private String mobile;

    @ApiModelProperty(value = "邮箱地址")
    private String email;

    @ApiModelProperty(value = "过期类型(长期，周期，天数)")
    @TableField("expired_type")
    private Integer expiredType;

    @ApiModelProperty(value = "是否是第一次登录")
    @TableField("first_login")
    private Boolean firstLogin;

    @ApiModelProperty(value = "第一次登录时间")
    @TableField("first_login_time")
    private Date firstLoginTime;

    @ApiModelProperty(value = "上一次登录时间")
    @TableField("last_login_time")
    private Date lastLoginTime;

    @ApiModelProperty(value = "账户锁定时间")
    @TableField("locked_time")
    private Date lockedTime;

    @ApiModelProperty(value = "账号生效时间")
    @TableField("enabled_time")
    private Date enabledTime;

    @ApiModelProperty(value = "账户过期时间")
    @TableField("expired_time")
    private Date expiredTime;

    @ApiModelProperty(value = "盐")
    private String salt;

    @ApiModelProperty(value = "开始时间")
    @TableField("start_time")
    private Date startTime;

    @ApiModelProperty(value = "结束时间")
    @TableField("end_time")
    private Date endTime;

    @ApiModelProperty(value = "性别(‘M’:男,'F':女)")
    private String sex;

    @ApiModelProperty(value = "职位")
    private String position;

    @ApiModelProperty(value = "微信")
    private String wechat;

    @ApiModelProperty(value = "微信图片")
    @TableField("wechat_pic")
    private String wechatPic;

    @ApiModelProperty(value = "有效天数")
    @TableField("valid_days")
    private Integer validDays;

    @ApiModelProperty(value = "全名")
    @TableField("full_name")
    private String fullName;

    @ApiModelProperty(value = "工号")
    @TableField("work_num")
    private String workNum;

    @ApiModelProperty(value = "创建者id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "账号描述")
    private String description;

    @ApiModelProperty(value = "部门名称")
    @TableField(exist = false)
    private String orgName;

    @ApiModelProperty(value = "部门全名称")
    @TableField(exist = false)
    private String orgFullName;

    @ApiModelProperty(value = "公司名称")
    @TableField(exist = false)
    private String companyName;

    @ApiModelProperty(value = "启禁用日志")
    @TableField(exist = false)
    private List<AccountEnableLog> logs;

    @ApiModelProperty(value = "企业地址")
    @TableField(exist = false)
    private String companyAddress;

    @ApiModelProperty(value = "app注册id")
    @TableField("app_registration_id")
    private String appRegistrationId;

    @ApiModelProperty(value = "app注册id")
    @TableField("company_default_admin")
    private Integer companyDefaultAdmin;

    @ApiModelProperty(value = "备注1")
    @TableField("remark_first")
    private String remarkFirst;

    @ApiModelProperty(value = "备注2")
    @TableField("remark_second")
    private String remarkSecond;

    @ApiModelProperty(value = "备注3")
    @TableField("remark_third")
    private String remarkThird;


    @TableField(exist = false)
    private String enabledState;

    @TableField(exist = false)
    private String createTimeStr;

    @TableField(exist = false)
    private String expiredTimeStr;

    @TableField(exist = false)
    private String validDaysStr;

    @TableField(exist = false)
    private String department;

    @TableField(exist = false)
    private String orgCode;

    @ApiModelProperty(value = "经验池可见范围组别")
    @TableField(exist = false)
    private String group;

    @ApiModelProperty(value = "经验池可见范围批次")
    @TableField(exist = false)
    private String batchNo;

    @ApiModelProperty(value = "经验池可见范围备注")
    @TableField(exist = false)
    private String note;
    
    @ApiModelProperty(value = "身份证号")
    @TableField("id_number")
    private String idNumber;

    @ApiModelProperty(value = "是否开启用户的debug开放者模式")
    @TableField("dev")
    private Boolean dev;

    @ApiModelProperty(value = "1：删除 0：反之")
    @TableLogic
    private Integer deleted;

    @ApiModelProperty(value = "索引时间")
    @TableField(value = "index_time")
    private Date indexTime;

    @ApiModelProperty(value = "是否绑定微信，true 绑定，false 未绑定")
    @TableField(exist = false)
    private Boolean bindWeChat;

    @ApiModelProperty(value = "绑定状态")
    @TableField(exist = false)
    private String bindWeChatState;

    @ApiModelProperty(value = "关联角色名称")
    @TableField(exist = false)
    private String relationRoleNames;

}
