package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 账号启禁用日志
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-04-17
 */
@Data
@Api(tags = "AccountEnableLog", description = "")
@TableName("account_enable_log")
public class AccountEnableLog extends Model<AccountEnableLog> {

    private static final long serialVersionUID = 1L;


	private Long id;

@ApiModelProperty(value = "账号id")
	@TableField("account_id")
	private Long accountId;

@ApiModelProperty(value = "类型(1:启用2:停用)")
	private Integer type;

@ApiModelProperty(value = "停启用原因")
	private String reason;

	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;


	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
