package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 员工关联角色
 * </p>
 *
 * @author 谢海军
 * @since 2018-03-09
 */
@Data
@Api(tags = "AuthzAccountRole", description = "员工关联角色")
@TableName("authz_account_role")
public class AuthzAccountRole extends Model<AuthzAccountRole> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "账号id")
    @TableField("account_id")
    private Long accountId;

    @ApiModelProperty(value = "角色id")
    @TableField("role_id")
    private Long roleId;

    @ApiModelProperty(value = "站点id")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "创建者id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }


	public AuthzAccountRole() {
		super();
	}


	public AuthzAccountRole(Long id, Long accountId, Long roleId, Long siteId) {
		super();
		this.id = id;
		this.accountId = accountId;
		this.roleId = roleId;
		this.siteId = siteId;
	}
}
