package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author taoge123
 * @since 2020-03-17
 */
@Data
@ApiModel(value = "Internationalization", description = "")
@TableName("internationalization")
public class Internationalization {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
	private Long id;

	@ApiModelProperty(value = "模块code")
	@TableField("module_type")
	private String moduleType;

    @ApiModelProperty(value = "所属表名")
	@TableField("table_type")
	private String tableType;

	@ApiModelProperty(value = "name字段所属的数据id与module_name")
	@TableField("task_id")
	private Long taskId;

    @ApiModelProperty(value = "模块名称 ")
	@TableField("module_name")
	private String moduleName;

    @ApiModelProperty(value = "自定义中文名称")
	private String name;

	@ApiModelProperty(value = "终端类型：PC、WEIXIN ")
	@TableField("terminal_type")
	private String terminalType;

	@TableField("org_id")
	private Long orgId;

	@TableField("site_id")
	private Long siteId;

	@TableField("company_id")
	private Long companyId;

    @ApiModelProperty(value = "是否删除(0:否,1:是)")
	private Integer deleted;

    @ApiModelProperty(value = "创建者id")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

    @ApiModelProperty(value = "创建者名称")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

    @ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

    @ApiModelProperty(value = "更新者id")
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

    @ApiModelProperty(value = "修改者名称")
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

    @ApiModelProperty(value = "修改时间")
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;



}
