package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 短信发送以后状态的回馈信息
 * </p>
 *
 * @author 谢海军123
 * @since 2018-12-06
 */
@Data
@ApiModel(value = "SmsReturnReceip", description = "短信发送以后状态的回馈信息")
@TableName("sms_return_receip")
public class SmsReturnReceip {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "唯一编码")
	private Long id;

    @ApiModelProperty(value = "发送短信的记录id")
	@TableField("send_record_id")
	private String sendRecordId;

    @ApiModelProperty(value = "发送状态 1：等待回执，2：发送失败，3：发送成功")
	@TableField("send_status")
	private Integer sendStatus;

    @ApiModelProperty(value = "运营商短信错误码")
	@TableField("err_code")
	private String errCode;

    @ApiModelProperty(value = "手机号码(如果是批量发送，关联手机号批量发送表的id)")
	@TableField("phone_num")
	private String phoneNum;

    @ApiModelProperty(value = "模板ID")
	@TableField("template_code")
	private String templateCode;

    @ApiModelProperty(value = "发送的短信内容")
	private String content;

    @ApiModelProperty(value = "发送时间 :格式2017-05-25 00:00:00")
	@TableField("send_date")
	private Date sendDate;

    @ApiModelProperty(value = "接收时间 :格式2017-05-25 00:00:00")
	@TableField("receive_date")
	private Date receiveDate;

    @ApiModelProperty(value = "外部流水扩展字段")
	private String outId;

    @ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;



}
