package com.yizhi.system.application.enums;

import com.yizhi.util.application.json.JsonUtil;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 9:21 2018/3/9
 * @Modified By
 */
public enum SecurityReturnCode {

    INTERNAL_ERROR("1A00","系统内部错误"),

    ROLE_EXTIS("1AA1","新增角色信息已经存在"),
    ROLE_DELETE_FAIL("1AA2","删除角色失败"),
    ROLE_NOT_EXTIS("1AA3","角色不存在"),
    ROLE_ACCOUNT_DELETE_FAIL("1AA4","删除角色关联账户失败"),
    ROLE_ACCOUNT_AUTHORIZE_FAIL("1AA5","关联角色关联账户失败"),
    OPERATION_IDS_NOT_EXTIS("1AB1","操作权限ID无效"),

    PARAMENT_ERROR("1A00","参数不全："),
    ACCOUNT_PASSWD_ERROR("1A01","帐号或密码错误"),
    ACCOUNT_INVALID_ERROR("1A02","帐号失效"),
    ACCOUNT_LOCK_ERROR("1A03","帐号未开通或锁定"),
    NOT_SITE_ACCESS_AUTH("1A04","没有站点访问权限，不能登录该站点"),
    AUTH_CODE_ERROR("1A05","授权码错误"),
    NOT_MANAGE_ERROR("1A12","没有管理权限"),
    WINXIN_SAVE_ERROR("1A13","账号已经被绑定"),
    SENSITIVEWORD_ERROR("1A14","存在铭感词");
    SecurityReturnCode(String subcode, String submsg) {
        this.subcode = subcode;
        this.submsg = submsg;
    }

    private String subcode;
    private String submsg;

    public String getSubcode() {
        return subcode;
    }

    public String getSubmsg() {
        return submsg;
    }

    public String toJson() {
        return JsonUtil.object2Json(this);
    }
}
