package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.system.application.util.RightLeftIndex;
import com.yizhi.system.application.vo.*;
import com.yizhi.system.application.domain.Account;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.session.RowBounds;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface AccountMapper extends BaseMapper<Account> {


    List<Account> selectBatchIds(@Param("idList") Collection<? extends Serializable> idList);

    @Select("<script>" +
            "SELECT id,name,full_name fullName,remark_first status, org_id orgId,email, mobile, work_num workNum, sex, position, id_number idNumber, remark_second siteId " +
            "FROM account WHERE company_id = #{companyId} AND remark_second = #{siteId} AND remark_first='0' AND deleted = 0" +
            "<if test=\"userName != null and userName != '' \"> " +
            " AND name = #{userName}  " +
            "</if> order by tb.sort" +
            "</script>")
    List<OutsideUserVO> getRcUsers(@Param(value = "userName") String userName,
                                   @Param(value = "companyId") Long companyId,
                                   @Param(value = "siteId") String siteId);

    /**
     * 获取企业下的接入有效用户
     * @param companyId
     * @param enable
     * @return
     */
    @Select("<script>" +
            "SELECT id,name,full_name fullName,remark_first status, org_id orgId,email, mobile, work_num workNum, sex, position, id_number idNumber, remark_second siteId " +
            "FROM account WHERE company_id = #{companyId} AND deleted = 0" +
            "<if test='enable != null'> " +
            " AND enabled = #{enable}  " +
            "</if>" +
            "</script>")
    List<OutsideUserVO> getCompanyOutsideUsers(@Param(value = "companyId") Long companyId, @Param(value = "enable") Integer enable);

    /**
     * 查询重名的不同账号数量
     *
     * @param id
     * @param resourceName
     * @return
     */
    @Select("select count(*)  from account where "
            + "id <> #{accountId} and company_id=#{companyId} and name = #{accountName} AND deleted = 0")
    int countExistAccount(@Param(value = "accountId") Long accountId, @Param(value = "companyId") Long companyId, @Param(value = "accountName") String accountName);

    /**
     * 获取公司内账号关闭的人数
     *
     * @param companyId
     * @return
     */
    @Select("select count(*)  from account where company_id= #{companyId} and enabled=0 AND deleted = 0 ")
    int getCloseCountByCompanyId(@Param(value = "companyId") Long companyId);

    /**
     * 获取公司内总账号数
     *
     * @param companyId
     * @return
     */
    @Select("select count(*)  from account where company_id= #{companyId} AND deleted = 0 ")
    int getCountByCompanyId(@Param(value = "companyId") Long companyId);

    /**
     * RowBounds rowBounds 支持分页，selectVoteList要和xml配置id一致
     *
     * @param cid   企业
     * @param orgId 组织id
     * @return
     */
    List<OrgAccountVO> selectOrgAndAccount(@Param("cid") Long cid, @Param("orgId") Long orgId, @Param("queryStr") String queryStr);

    List<OrgAccountVO> selectOrgAndAccountByName(@Param("cid") Long cid, @Param("orgId") Long orgId, @Param("queryStr") String queryStr);

    /**
     * 查询用户
     *
     * @param cid
     * @param orgId
     * @param queryStr
     * @return
     */
    List<OrgAccountVO> selectAccount(@Param("cid") Long cid, @Param("orgId") Long orgId, @Param("queryStr") String queryStr);

    /**
     * 查询用户组信息
     *
     * @param cid
     * @param queryStr
     * @return
     */
    List<OrgAccountVO> selectUserGrouop(@Param("cid") Long cid, @Param("sid") Long sid, @Param("queryStr") String queryStr);

    /**
     * 根据用户名，姓名，或部门名称查询账号列表
     *
     * @param name
     * @param fullName
     * @param orgName
     * @return
     */
    List<UserInfoVO> selectUserInfo(@Param("name") String name, @Param("fullName") String fullName,
                                    @Param("orgName") String orgName, @Param("companyId") Long companyId,
                                    @Param("orgIds") List<Long> orgIds);

    /**
     * 返回用户ids 排序
     *
     * @param accountIdList
     * @return
     */
    List<Long> selectAccountIdList(@Param("accountIdList") List<Long> accountIdList);

    /**
     * 检查和给定worknum重复的员工总人数
     *
     * @param accountId
     * @param companyId
     * @param worknum
     * @return
     */
    @Select("select count(*)  from account where "
            + "id <> #{accountId} and company_id=#{companyId} and work_num = #{worknum} AND deleted = 0")
    int countExistWorknum(@Param(value = "accountId") Long accountId, @Param(value = "companyId") Long companyId, @Param(value = "worknum") String worknum);

//    /**
//     * 根基id查询
//     *
//     * @param ids
//     * @return
//     */
//    List<Account> selectByIds(@Param("ids") List<Long> ids);


    /**
     * 组织下人员接口-其他 -- 权限改造
     *
     * @param groupId
     * @param name
     * @param mobile
     * @param workNum
     * @return
     */
    List<Account> orgAccountListPageOther(@Param("groupId") Long groupId, @Param("name") String name, @Param("mobile") String mobile,
                                          @Param("workNum") String workNum, @Param("email") String email,
                                          @Param("enabled") Integer enabled, RowBounds rowBounds);

    Integer orgAccountListPageOtherCount(@Param("groupId") Long groupId, @Param("name") String name, @Param("mobile") String mobile,
                                         @Param("workNum") String workNum, @Param("email") String email,
                                         @Param("enabled") Integer enabled);

    /**
     * 组织下人员接口-部门 -- 权限改造
     *
     * @param rightLeftIndices
     * @param name
     * @param mobile
     * @param workNum
     * @param fullName
     * @param enabled
     * @return
     */
    List<Account> orgAccountListPage(@Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices,
                                     @Param("name") String name, @Param("mobile") String mobile,
                                     @Param("orgId") Long orgId,
                                     @Param("workNum") String workNum, @Param("fullName") String fullName,
                                     @Param("email") String email, @Param("enabled") Integer enabled,
                                     @Param("companyId") Long companyId, RowBounds rowBounds);

    Integer orgAccountListPageCount(@Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices,
                                    @Param("name") String name, @Param("mobile") String mobile,
                                    @Param("orgId") Long orgId,
                                    @Param("workNum") String workNum, @Param("fullName") String fullName,
                                    @Param("email") String email, @Param("enabled") Integer enabled,
                                    @Param("companyId") Long companyId);

    List<Account> orgAccountList(@Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices,
                                 @Param("enabled") Integer enabled, @Param("companyId") Long companyId);

    int orgAccountListCount(@Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices,
                            @Param("enabled") Integer enabled, @Param("companyId") Long companyId);

    /**
     * 根据管辖区id获取用户id
     *
     * @param groupIds
     * @return
     */
    List<Long> getIdsByUserGroupIds(@Param("groupIds") List<Long> groupIds);

    /**
     * 分页查询当前站点下的用户
     *
     * @param orgIds
     * @param ids
     * @return
     */
    List<Account> searchSitePage(@Param("name") String name, @Param("mobile") String mobile,
                                 @Param("workNum") String workNum, @Param("fullName") String fullName,
                                 @Param("email") String email, @Param("enabled") Integer enabled,
                                 @Param("orgIds") List<Long> orgIds, @Param("ids") List<Long> ids, RowBounds rowBounds);

    /**
     * 分页查询当前站点下的用户
     *
     * @param orgIds
     * @param ids
     * @return
     */
    Integer searchSitePageCount(@Param("name") String name, @Param("mobile") String mobile,
                                @Param("workNum") String workNum, @Param("fullName") String fullName,
                                @Param("email") String email, @Param("enabled") Integer enabled,
                                @Param("orgIds") List<Long> orgIds, @Param("ids") List<Long> ids);

    /**
     * 根据账号id来获取组织部门id
     * https://blog.csdn.net/aiyawalie/article/details/52954138
     *
     * @param accountId
     * @return
     */
    @Select("select org_id from account where id = #{accoungId}")
    Long getOrgIdByAccountId(@Param("accoungId") Long accoungId);

    /**
     * 根据用户id集合查询用户信息
     *
     * @param ids
     * @return
     */
    @Select("<script>" +
            "SELECT t.id,t.`name`,t.sex,t.full_name AS fullName,t.head_portrait AS headPortrait,o.id AS orgId,o.`name` AS orgName,t.enabled,t.company_id as companyId " +
            "FROM (SELECT id,`name`,head_portrait,full_name,org_id,enabled,sex,company_id FROM account WHERE 1=1 AND deleted = 0" +
            "<if test='ids != null'> " +
            " AND id IN " +
            "<foreach collection='ids' open='(' close=')' separator=',' item='userId' index='index'> " +
            "#{userId,jdbcType=BIGINT} " +
            "</foreach>" + //<if test="idNumber != null and idNumber != ''">
            "</if>" +
            " ORDER BY create_time DESC) t LEFT JOIN organization o " +
            " ON t.org_id=o.id " +
            "</script>")
    List<AccountVO> idsGet(@Param("ids") List<Long> ids);

    /**
     * 通过给定accountIds 结合条件查询
     *
     * @param keyWord  用户名 姓名 工号
     * @param position 职位
     * @param orgId    部门id
     * @param page
     * @return
     */
    List<ReportAccountRespVO> getVoByIds(@Param("accountIds") List<Long> accountIds, @Param("keyWord") String keyWord, @Param("position") String position, @Param("orgId") Long orgId, @Param("orgName") String orgName, Page page);

    /**
     * 查询站点下的人数
     *
     * @param siteId
     * @param companyId
     * @return
     */
    @Select("select count(a.id) from account a " +
            "left join organization o on o.id = a.org_id " +
            "left join authz_group_member gm on ((gm.member_id = o.id and gm.type = 1) or (gm.member_id = a.id and type = 2)) " +
            "where a.company_id = #{companyId} and gm.group_id = (select user_group_id from site where id = #{siteId}) AND a.deleted = 0")
    Integer getSiteAccountNum(@Param("siteId") Long siteId, @Param("companyId") Long companyId);

    /**
     * 查找公司下所有的账号名
     *
     * @param companyId
     * @return
     */
    @Select("select name from account where company_id = #{companyId} AND deleted = 0")
    List<String> selectNamesByCompanyId(@Param("companyId") Long companyId);

    /**
     * 查找公司下用户的手机号码
     *
     * @param companyId
     * @return
     */
    @Select("select mobile from account where company_id = #{companyId} and enabled=1 and mobile!='' AND deleted = 0")
    List<String> selectMobilesByCompanyId(@Param("companyId") Long companyId);


    /**
     * 查找公司下所有的工号
     *
     * @param companyId
     * @return
     */
    @Select("select work_num from account where company_id = #{companyId} AND deleted = 0")
    List<String> selectWorkNumsByCompanyId(@Param("companyId") Long companyId);

    /**
     * 管辖范围内，查询用户列表，指定部门
     *
     * @param names
     * @param rightLeftIndices
     * @param companyId
     * @return
     */
    List<Account> listByNamesInManageRangeOrg(@Param("names") List<String> names,
                                              @Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices,
                                              @Param("companyId") Long companyId);

    /**
     * 管辖范围内，查询用户列表，指定用户组
     *
     * @param userGroupIds
     * @param companyId
     * @return
     */
    List<Account> listByNamesInManageRangeUserGroup(@Param("names") List<String> names, @Param("userGroupIds") List<Long> userGroupIds, @Param("companyId") Long companyId);

    @Select("<script>" +
            "SELECT a.id AS userId,a.`name` AS userName,a.full_name AS userFullName, " +
            "a.org_id AS orgId,o.`name` AS orgName,a.enabled AS status,,a.create_time AS createTime " +
            "FROM " +
            "account a LEFT JOIN organization o ON a.org_id = o.id " +
            "WHERE enabled=1 and 1=1  AND a.deleted = 0" +
            "<if test='orgs != null'> " +
            " AND a.org_id IN " +
            "<foreach collection='orgs' open='(' close=')' separator=',' item='orgId' index='index'> " +
            "#{orgId,jdbcType=BIGINT} " +
            "</foreach>" + //<if test="idNumber != null and idNumber != ''">
            "</if>" +
            "<if test='orgName != null'> " +
            "AND o.`name` LIKE #{orgName} " +
            "</if>" +
            "<if test='userName != null'> " +
            "AND a.`name` LIKE #{userName} " +
            "</if>" +
            "ORDER BY a.enabled DESC,a.id ASC " +
            "</script>")
    List<ReportAccountRespVO> getOrgsCountUser(@Param("orgs") List<Long> orgs,
                                               @Param("orgName") String orgName,
                                               @Param("userName") String userName);

    @Select("<script>" +
            "SELECT a.id AS userId,a.`name` AS userName,a.full_name AS userFullName, " +
            "a.org_id AS orgId,o.`name` AS orgName,a.enabled AS status,,a.create_time AS createTime " +
            "FROM " +
            "account a LEFT JOIN organization o ON a.org_id = o.id " +
            "WHERE 1=1 AND a.deleted = 0" +
            "<if test='orgs != null'> " +
            " AND a.org_id IN " +
            "<foreach collection='orgs' open='(' close=')' separator=',' item='orgId' index='index'> " +
            "#{orgId,jdbcType=BIGINT} " +
            "</foreach>" + //<if test="idNumber != null and idNumber != ''">
            "</if>" +
            "<if test='orgName != null'> " +
            "AND o.`name` LIKE #{orgName} " +
            "</if>" +
            "<if test='userName != null'> " +
            "AND a.`name` LIKE #{userName} " +
            "</if>" +
            "ORDER BY a.enabled DESC,a.id ASC " +
            "</script>")
    List<ReportAccountRespVO> getOrgsCountUser(@Param("page") Page<ReportAccountRespVO> page,
                                               @Param("orgs") List<Long> orgs,
                                               @Param("orgName") String orgName,
                                               @Param("userName") String userName);


    @Select("<script>" +
            "SELECT t.userId,t.workNum,t.userName,t.userFullName,t.orgId,t.orgName,t.orgCode,t.status,t.createTime,t.email,t.companyId FROM (" +
            " SELECT a.email,a.id AS userId,a.work_num AS workNum,a.`name` AS userName,a.full_name AS userFullName, " +
            " a.org_id AS orgId,o.`name` AS orgName,o.`code` AS orgCode,a.enabled AS status,a.create_time AS createTime," +
            " a.company_id AS companyId" +
            " FROM " +
            " account a LEFT JOIN organization o ON a.org_id = o.id " +
            " WHERE 1=1 AND a.deleted = 0" +
            "<if test='isAllAccout==false'>" +
            " AND a.enabled = 1 " +
            "</if>" +
            "<if test='nameOrFullName != null'>" +
            "AND (a.`name` LIKE CONCAT('%', #{nameOrFullName}, '%') OR a.full_name LIKE CONCAT('%', #{nameOrFullName}, '%') ) " +
            "</if>" +
            "<if test='orgs != null'> " +
            " AND (a.org_id IN " +
            "<foreach collection='orgs' open='(' close=')' separator=',' item='orgId' index='index'> " +
            "#{orgId,jdbcType=BIGINT} " +
            "</foreach>" + //<if test="idNumber != null and idNumber != ''">
            " OR a.id IN " +
            "<foreach collection='orgs' open='(' close=')' separator=',' item='accountId' index='index'> " +
            "#{accountId,jdbcType=BIGINT} " +
            "</foreach>" + //<if test="idNumber != null and idNumber != ''">
            "<if test='groupId != null and groupId != 0'>" +
            " OR a.id IN (select member_id from authz_group_member where group_id = #{groupId} and type = 2)" +
            "</if>" +
            " ) " +
            "</if>" +
            "<if test='orgs == null and groupId != null and groupId != 0'>" +
            " AND a.id IN (select member_id from authz_group_member where group_id = #{groupId} and type = 2)" +
            "</if>" +
            ") t ORDER BY t.status DESC,t.userId ASC " +
            "</script>")
    List<ReportAccountRespVO> getOrgsRangeUser(@Param("orgs") List<Long> orgs,
                                               @Param("isAllAccout") boolean isAllAccout,
                                               @Param("nameOrFullName") String nameOrFullName,
                                               @Param("groupId") Long groupId);

    @Select("<script>" +
            "SELECT id AS userId,name AS userName FROM account" +
            " WHERE 1=1 AND deleted = 0 " +
            "<if test='orgs != null'> " +
            " AND org_id IN " +
            "<foreach collection='orgs' open='(' close=')' separator=',' item='orgId' index='index'> " +
            "#{orgId,jdbcType=BIGINT} " +
            "</foreach>" +
            "</if>" +
            " GROUP BY userName" +
            "</script>")
    List<ReportAccountRespVO> getRangeUserNames(@Param("orgs") Set<Long> orgs);

    @Select("<script>" +
            "SELECT count(0) " +
            "FROM " +
            "account a LEFT JOIN organization o ON a.org_id = o.id " +
            "WHERE 1=1  AND deleted = 0" +
            "<if test='isAllAccout==false'>" +
            "AND a.enabled = 1 " +
            "</if>" +
            "<if test='nameOrFullName != null'>" +
            "AND (a.`name` LIKE CONCAT('%', #{nameOrFullName}, '%') OR a.full_name LIKE CONCAT('%', #{nameOrFullName}, '%') ) " +
            "</if>" +
            "<if test='orgs != null'> " +
            " AND (a.org_id IN " +
            "<foreach collection='orgs' open='(' close=')' separator=',' item='orgId' index='index'> " +
            "#{orgId,jdbcType=BIGINT} " +
            "</foreach>" + //<if test="idNumber != null and idNumber != ''">
            " OR a.id IN " +
            "<foreach collection='orgs' open='(' close=')' separator=',' item='accountId' index='index'> " +
            "#{accountId,jdbcType=BIGINT} " +
            "</foreach>" + //<if test="idNumber != null and idNumber != ''">
            "<if test='groupId != null and groupId != 0'>" +
            " OR a.id IN (select member_id from authz_group_member where group_id = #{groupId} and type = 2)" +
            "</if>" +
            " ) " +
            "</if>" +
            "<if test='orgs == null and groupId != null and groupId != 0'>" +
            " AND a.id IN (select member_id from authz_group_member where group_id = #{groupId} and type = 2)" +
            "</if>" +
            "ORDER BY a.enabled DESC,a.id ASC " +
            "</script>")
    Long getOrgsRangeUserCountNum(@Param("orgs") List<Long> orgs, @Param("isAllAccout") boolean isAllAccout,
                                  @Param("nameOrFullName") String nameOrFullName,
                                  @Param("groupId") Long groupId);

    /**
     * 根据组织id查询组织下的用户id
     *
     * @param OrgId
     * @return
     */
    @Select("SELECT a.id FROM account a WHERE a.org_id = #{OrgId} AND a.deleted = 0")
    List<Long> getAccountsByOrgId(@Param("OrgId") Long OrgId);

    /**
     * 获取id
     *
     * @param account
     * @return
     */
    Set<Long> getIds(@Param("account") Account account);

    /**
     * 获取id
     *
     * @param account
     * @param rightLeftIndices
     * @return
     */
    Set<Long> getIdsInManage(@Param("account") Account account, @Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices);

    /**
     * 获取用户
     *
     * @param companyId
     * @param rightLeftIndices
     * @return
     */
    Set<Account> getInManage(@Param("companyId") Long companyId,
                             @Param("rightLeftIndices") Collection<RightLeftIndex> rightLeftIndices,
                             @Param("accountIds") Collection<Long> accountIds);

    /**
     * @param names
     * @param companyId
     * @return
     */
    List<Account> getIdsByNames(@Param("names") List<String> names, @Param("companyId") Long companyId);


    /**
     * 根据companId,id查询账号姓名
     *
     * @param companyId
     * @param ids
     * @return
     */
    List<Account> getAccountsByCompanIdIds(@Param("companyId") Long companyId, @Param("ids") List<Long> ids);

    /**
     * 根据条件查询一个部门下的用户id
     *
     * @param companyId
     * @param orgId
     * @param enabled
     * @return
     */
    @Select("select id from account " +
            "where company_id = #{companyId} " +
            "and org_id = #{orgId} " +
            "and enabled = #{enabled} AND deleted = 0")
    List<Long> listAccountIdByOrgIdAndEnable(@Param("companyId") Long companyId, @Param("orgId") Long orgId, @Param("enabled") Integer enabled);

    /**
     * 查询手机号码是否已经存在系统中
     *
     * @param mobile
     * @param companyId
     * @return
     */
    @Select("select count(*)  from account where "
            + "id <> #{accountId} and company_id=#{companyId} and mobile = #{mobile} AND deleted = 0")
    int countExistMobile(@Param("accountId") Long accountId, @Param("companyId") Long companyId, @Param("mobile") String mobile);

    List<ReportAccountRespVO> getReportAccountRespVO(@Param("companyId") Long companyId, @Param("enabled") Boolean enabled,
                                                     @Param("accountName") String accountName, @Param("orgName") String orgName,
                                                     @Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices,
                                                     @Param("accountIds") List<Long> accountIds,
                                                     @Param("orgIds") List<Long> orgIds);

    List<ReportAccountRespVO> getReportAccountRespVO(@Param("companyId") Long companyId, @Param("enabled") Boolean enabled,
                                                     @Param("accountName") String accountName, @Param("orgName") String orgName,
                                                     @Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices,
                                                     @Param("accountIds") List<Long> accountIds,
                                                     @Param("orgIds") List<Long> orgIds,
                                                     Page page);

    List<Account> getByParam(@Param("companyId") Long companyId, @Param("enabled") Boolean enabled,
                             @Param("accountName") String accountName, @Param("mobile") String mobile,
                             @Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices,
                             @Param("accountIds") List<Long> accountIds, Page<Account> page);

    Long getReportAccountRespVOCount(@Param("companyId") Long companyId, @Param("enabled") Boolean enabled,
                                     @Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices,
                                     @Param("accountIds") List<Long> accountIds);

    List<Long> getAccountId(@Param("companyId") Long companyId, @Param("enabled") Boolean enabled,
                            @Param("accountName") String accountName, @Param("orgName") String orgName,
                            @Param("rightLeftIndices") List<RightLeftIndex> rightLeftIndices,
                            @Param("accountIds") List<Long> accountIds);

    @Select("select id from account where company_id = #{companyId} AND deleted = 0")
    Set<Long> getIdByCompanyId(@Param("companyId") Long companyId);

    List<AccountCountVO> getAccountCount(@Param("companyId") Long companyId);

    /**
     * 查找公司下除了指定用户的手机号
     *
     * @param companyId
     * @return
     */
    @Select("select mobile from account where company_id = #{companyId} and id != #{accountId} and mobile!='' AND deleted = 0")
    List<String> selectMobilesExceptAccountId(@Param("companyId") Long companyId, @Param("accountId") Long accountId);

    /**
     * 查询站点下的管理员
     *
     * @param siteId
     * @return
     */
    List<Account> selectManagerList(@Param("siteId") Long siteId, @Param("name") String name, RowBounds rowBounds);

    Integer selectManagerCount(@Param("siteId") Long siteId, @Param("name") String name);

    /**
     * 根据用户名，姓名，或部门名称查询账号列表
     *
     * @param name
     * @param fullName
     * @param orgName
     * @return
     */
    List<UserInfoVO> getUser(@Param("name") String name, @Param("fullName") String fullName,
                             @Param("orgName") String orgName, @Param("companyId") Long companyId,
                             @Param("orgIds") List<Long> orgIds);

    Long findSiteId(@Param("accountId")Long accountId);
}
