package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.system.application.domain.AuthzResource;
import io.swagger.annotations.ApiParam;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.session.RowBounds;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 操作表 Mapper 接口
 * </p>
 *
 * @author 谢海军123
 * @since 2018-03-09
 */
public interface AuthzResourceMapper extends BaseMapper<AuthzResource> {

    /**
     * 根据账户ID查询操作权限
     *
     * @param accountId
     * @return
     */
    @Select("SELECT t.* FROM authz_resource t WHERE t.id IN (SELECT t1.operation_id FROM role_operation t1 " +
            " WHERE t1.role_id IN (SELECT t2.role_id FROM authz_account_role t2 where t2.account_id=#{accountId}))")
    List<AuthzResource> getOperationByAccountId(Long accountId);

    /**
     * 根据角色id查询当前角色下的访问权限
     *
     * @param roleId
     * @return
     */
    @Select("select tb.`url` from authz_resource tb " +
            "left join authz_menu_resource mo on mo.resource_id = tb.id " +
            "left join authz_role_menu rm on rm.menu_id = mo.menu_id and rm.role_id = #{roleId} " +
            "where tb.status = 1 and rm.role_id = #{roleId}")
    Set<String> getUrlByRoleId(@Param("roleId") Long roleId);

    /**
     * 分页查询资源（AuthzResource）信息
     *
     * @param name
     * @param rowBounds
     * @return
     */
    List<AuthzResource> listAuthzResource(@Param("name") String name,@Param("status")Integer status ,RowBounds rowBounds);
    Integer queryAuthzResourceNum(@Param("name") String name,@Param("status")Integer status ,RowBounds rowBounds);

    /**
     * 根据菜单Id，查询相应资源
     * @param menuId
     * @return
     */
    List<AuthzResource> menuResourceList(@ApiParam("menuId") Long menuId);
}
